/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergOptimizationPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergOptimizationPropertiesOutput> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(IcebergOptimizationPropertiesOutput.getter(IcebergOptimizationPropertiesOutput::roleArn)).setter(IcebergOptimizationPropertiesOutput.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> COMPACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Compaction").getter(IcebergOptimizationPropertiesOutput.getter(IcebergOptimizationPropertiesOutput::compaction)).setter(IcebergOptimizationPropertiesOutput.setter(Builder::compaction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compaction").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Retention").getter(IcebergOptimizationPropertiesOutput.getter(IcebergOptimizationPropertiesOutput::retention)).setter(IcebergOptimizationPropertiesOutput.setter(Builder::retention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ORPHAN_FILE_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OrphanFileDeletion").getter(IcebergOptimizationPropertiesOutput.getter(IcebergOptimizationPropertiesOutput::orphanFileDeletion)).setter(IcebergOptimizationPropertiesOutput.setter(Builder::orphanFileDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrphanFileDeletion").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(IcebergOptimizationPropertiesOutput.getter(IcebergOptimizationPropertiesOutput::lastUpdatedTime)).setter(IcebergOptimizationPropertiesOutput.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, COMPACTION_FIELD, RETENTION_FIELD, ORPHAN_FILE_DELETION_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergOptimizationPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final Map<String, String> compaction;
    private final Map<String, String> retention;
    private final Map<String, String> orphanFileDeletion;
    private final Instant lastUpdatedTime;

    private IcebergOptimizationPropertiesOutput(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.compaction = builder.compaction;
        this.retention = builder.retention;
        this.orphanFileDeletion = builder.orphanFileDeletion;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasCompaction() {
        return this.compaction != null && !(this.compaction instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> compaction() {
        return this.compaction;
    }

    public final boolean hasRetention() {
        return this.retention != null && !(this.retention instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> retention() {
        return this.retention;
    }

    public final boolean hasOrphanFileDeletion() {
        return this.orphanFileDeletion != null && !(this.orphanFileDeletion instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> orphanFileDeletion() {
        return this.orphanFileDeletion;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompaction() ? this.compaction() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetention() ? this.retention() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrphanFileDeletion() ? this.orphanFileDeletion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOptimizationPropertiesOutput)) {
            return false;
        }
        IcebergOptimizationPropertiesOutput other = (IcebergOptimizationPropertiesOutput)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && this.hasCompaction() == other.hasCompaction() && Objects.equals(this.compaction(), other.compaction()) && this.hasRetention() == other.hasRetention() && Objects.equals(this.retention(), other.retention()) && this.hasOrphanFileDeletion() == other.hasOrphanFileDeletion() && Objects.equals(this.orphanFileDeletion(), other.orphanFileDeletion()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergOptimizationPropertiesOutput").add("RoleArn", (Object)this.roleArn()).add("Compaction", this.hasCompaction() ? this.compaction() : null).add("Retention", this.hasRetention() ? this.retention() : null).add("OrphanFileDeletion", this.hasOrphanFileDeletion() ? this.orphanFileDeletion() : null).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Compaction": {
                return Optional.ofNullable(clazz.cast(this.compaction()));
            }
            case "Retention": {
                return Optional.ofNullable(clazz.cast(this.retention()));
            }
            case "OrphanFileDeletion": {
                return Optional.ofNullable(clazz.cast(this.orphanFileDeletion()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Compaction", COMPACTION_FIELD);
        map.put("Retention", RETENTION_FIELD);
        map.put("OrphanFileDeletion", ORPHAN_FILE_DELETION_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergOptimizationPropertiesOutput, T> g) {
        return obj -> g.apply((IcebergOptimizationPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private Map<String, String> compaction = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> retention = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> orphanFileDeletion = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOptimizationPropertiesOutput model) {
            this.roleArn(model.roleArn);
            this.compaction(model.compaction);
            this.retention(model.retention);
            this.orphanFileDeletion(model.orphanFileDeletion);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getCompaction() {
            if (this.compaction instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.compaction;
        }

        public final void setCompaction(Map<String, String> compaction) {
            this.compaction = ParametersMapCopier.copy(compaction);
        }

        @Override
        public final Builder compaction(Map<String, String> compaction) {
            this.compaction = ParametersMapCopier.copy(compaction);
            return this;
        }

        public final Map<String, String> getRetention() {
            if (this.retention instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.retention;
        }

        public final void setRetention(Map<String, String> retention) {
            this.retention = ParametersMapCopier.copy(retention);
        }

        @Override
        public final Builder retention(Map<String, String> retention) {
            this.retention = ParametersMapCopier.copy(retention);
            return this;
        }

        public final Map<String, String> getOrphanFileDeletion() {
            if (this.orphanFileDeletion instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.orphanFileDeletion;
        }

        public final void setOrphanFileDeletion(Map<String, String> orphanFileDeletion) {
            this.orphanFileDeletion = ParametersMapCopier.copy(orphanFileDeletion);
        }

        @Override
        public final Builder orphanFileDeletion(Map<String, String> orphanFileDeletion) {
            this.orphanFileDeletion = ParametersMapCopier.copy(orphanFileDeletion);
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public IcebergOptimizationPropertiesOutput build() {
            return new IcebergOptimizationPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergOptimizationPropertiesOutput> {
        public Builder roleArn(String var1);

        public Builder compaction(Map<String, String> var1);

        public Builder retention(Map<String, String> var1);

        public Builder orphanFileDeletion(Map<String, String> var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

