/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.update.AddAction;
import software.amazon.awssdk.enhanced.dynamodb.update.DeleteAction;
import software.amazon.awssdk.enhanced.dynamodb.update.RemoveAction;
import software.amazon.awssdk.enhanced.dynamodb.update.SetAction;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateAction;

@SdkPublicApi
public final class UpdateExpression {
    private final List<RemoveAction> removeActions;
    private final List<SetAction> setActions;
    private final List<DeleteAction> deleteActions;
    private final List<AddAction> addActions;

    private UpdateExpression(Builder builder) {
        this.removeActions = builder.removeActions;
        this.setActions = builder.setActions;
        this.deleteActions = builder.deleteActions;
        this.addActions = builder.addActions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RemoveAction> removeActions() {
        return Collections.unmodifiableList(new ArrayList<RemoveAction>(this.removeActions));
    }

    public List<SetAction> setActions() {
        return Collections.unmodifiableList(new ArrayList<SetAction>(this.setActions));
    }

    public List<DeleteAction> deleteActions() {
        return Collections.unmodifiableList(new ArrayList<DeleteAction>(this.deleteActions));
    }

    public List<AddAction> addActions() {
        return Collections.unmodifiableList(new ArrayList<AddAction>(this.addActions));
    }

    public static UpdateExpression mergeExpressions(UpdateExpression expression1, UpdateExpression expression2) {
        if (expression1 == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression1;
        }
        Builder builder = UpdateExpression.builder();
        builder.removeActions = Stream.concat(expression1.removeActions.stream(), expression2.removeActions.stream()).collect(Collectors.toList());
        builder.setActions = Stream.concat(expression1.setActions.stream(), expression2.setActions.stream()).collect(Collectors.toList());
        builder.deleteActions = Stream.concat(expression1.deleteActions.stream(), expression2.deleteActions.stream()).collect(Collectors.toList());
        builder.addActions = Stream.concat(expression1.addActions.stream(), expression2.addActions.stream()).collect(Collectors.toList());
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateExpression that = (UpdateExpression)o;
        if (this.removeActions != null ? !this.removeActions.equals(that.removeActions) : that.removeActions != null) {
            return false;
        }
        if (this.setActions != null ? !this.setActions.equals(that.setActions) : that.setActions != null) {
            return false;
        }
        if (this.deleteActions != null ? !this.deleteActions.equals(that.deleteActions) : that.deleteActions != null) {
            return false;
        }
        return this.addActions != null ? this.addActions.equals(that.addActions) : that.addActions == null;
    }

    public int hashCode() {
        int result = this.removeActions != null ? this.removeActions.hashCode() : 0;
        result = 31 * result + (this.setActions != null ? this.setActions.hashCode() : 0);
        result = 31 * result + (this.deleteActions != null ? this.deleteActions.hashCode() : 0);
        result = 31 * result + (this.addActions != null ? this.addActions.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private List<RemoveAction> removeActions = new ArrayList<RemoveAction>();
        private List<SetAction> setActions = new ArrayList<SetAction>();
        private List<DeleteAction> deleteActions = new ArrayList<DeleteAction>();
        private List<AddAction> addActions = new ArrayList<AddAction>();

        private Builder() {
        }

        public Builder addAction(RemoveAction action) {
            this.removeActions.add(action);
            return this;
        }

        public Builder addAction(SetAction action) {
            this.setActions.add(action);
            return this;
        }

        public Builder addAction(DeleteAction action) {
            this.deleteActions.add(action);
            return this;
        }

        public Builder addAction(AddAction action) {
            this.addActions.add(action);
            return this;
        }

        public Builder actions(List<? extends UpdateAction> actions) {
            this.replaceActions(actions);
            return this;
        }

        public Builder actions(UpdateAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public UpdateExpression build() {
            return new UpdateExpression(this);
        }

        private void replaceActions(List<? extends UpdateAction> actions) {
            if (actions != null) {
                this.removeActions = new ArrayList<RemoveAction>();
                this.setActions = new ArrayList<SetAction>();
                this.deleteActions = new ArrayList<DeleteAction>();
                this.addActions = new ArrayList<AddAction>();
                actions.forEach(this::assignAction);
            }
        }

        private void assignAction(UpdateAction action) {
            if (action instanceof RemoveAction) {
                this.addAction((RemoveAction)action);
            } else if (action instanceof SetAction) {
                this.addAction((SetAction)action);
            } else if (action instanceof DeleteAction) {
                this.addAction((DeleteAction)action);
            } else if (action instanceof AddAction) {
                this.addAction((AddAction)action);
            } else {
                throw new IllegalArgumentException(String.format("Do not recognize UpdateAction: %s", action.getClass()));
            }
        }
    }
}

