/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import io.github.classgraph.ClassGraph;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;

public final class ReflectionUtils {
    private static ReflectionDriver reflectionDriver;

    private ReflectionUtils() {
    }

    private static Object getFieldVal(Class<?> cls, Object obj, String fieldName, boolean throwException) throws IllegalArgumentException {
        block4: {
            try {
                for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
                    for (Field field : reflectionDriver.getDeclaredFields(c)) {
                        if (!field.getName().equals(fieldName)) continue;
                        return reflectionDriver.getField(obj, field);
                    }
                }
            }
            catch (Throwable e) {
                if (!throwException) break block4;
                throw new IllegalArgumentException("Can't read " + (obj == null ? "static " : "") + " field \"" + fieldName + "\": " + e);
            }
        }
        return null;
    }

    public static Object getFieldVal(Object obj, String fieldName, boolean throwException) throws IllegalArgumentException {
        if (obj == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.getFieldVal(obj.getClass(), obj, fieldName, throwException);
    }

    public static Object getStaticFieldVal(Class<?> cls, String fieldName, boolean throwException) throws IllegalArgumentException {
        if (cls == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.getFieldVal(cls, null, fieldName, throwException);
    }

    public static Object invokeMethod(Object obj, String methodName, boolean throwException) throws IllegalArgumentException {
        if (obj == null || methodName == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeMethod(obj, reflectionDriver.findMethod(obj.getClass(), methodName, new Class[0]), new Object[0]);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object param, boolean throwException) throws IllegalArgumentException {
        if (obj == null || methodName == null || argType == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeMethod(obj, reflectionDriver.findMethod(obj.getClass(), methodName, argType), param);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, boolean throwException) throws IllegalArgumentException {
        if (cls == null || methodName == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeStaticMethod(reflectionDriver.findMethod(cls, methodName, new Class[0]), new Object[0]);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object param, boolean throwException) throws IllegalArgumentException {
        if (cls == null || methodName == null || argType == null) {
            if (throwException) {
                throw new IllegalArgumentException("Unexpected null argument");
            }
            return null;
        }
        try {
            return reflectionDriver.invokeStaticMethod(reflectionDriver.findMethod(cls, methodName, argType), param);
        }
        catch (Throwable e) {
            if (throwException) {
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
            return null;
        }
    }

    public static Class<?> classForNameOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            return null;
        }
    }

    static {
        if (ClassGraph.CIRCUMVENT_ENCAPSULATION) {
            try {
                reflectionDriver = new NarcissusReflectionDriver();
            }
            catch (Throwable t) {
                System.err.println("Could not load Narcissus reflection driver: " + t);
            }
        }
        if (reflectionDriver == null) {
            reflectionDriver = new StandardReflectionDriver();
        }
    }

    private static class NarcissusReflectionDriver
    extends ReflectionDriver {
        private final Class<?> narcissusClass;
        private final Method getDeclaredMethods;
        private final Method findClass;
        private final Method getDeclaredConstructors;
        private final Method getDeclaredFields;
        private final Method getField;
        private final Method getStaticField;
        private final Method invokeMethod;
        private final Method invokeStaticMethod;

        NarcissusReflectionDriver() throws Exception {
            StandardReflectionDriver drv = new StandardReflectionDriver();
            this.narcissusClass = drv.findClass("io.github.toolfactory.narcissus.Narcissus");
            this.findClass = drv.findMethod(this.narcissusClass, "findClass", String.class);
            this.getDeclaredMethods = drv.findMethod(this.narcissusClass, "getDeclaredMethods", Class.class);
            this.getDeclaredConstructors = drv.findMethod(this.narcissusClass, "getDeclaredConstructors", Class.class);
            this.getDeclaredFields = drv.findMethod(this.narcissusClass, "getDeclaredFields", Class.class);
            this.getField = drv.findMethod(this.narcissusClass, "getField", Object.class, Field.class);
            this.getStaticField = drv.findMethod(this.narcissusClass, "getStaticField", Field.class);
            this.invokeMethod = drv.findMethod(this.narcissusClass, "invokeMethod", Object.class, Method.class, Object[].class);
            this.invokeStaticMethod = drv.findMethod(this.narcissusClass, "invokeStaticMethod", Method.class, Object[].class);
        }

        @Override
        boolean makeAccessible(AccessibleObject accessibleObject) {
            return true;
        }

        @Override
        Class<?> findClass(String className) throws Exception {
            return (Class)this.findClass.invoke(null, className);
        }

        @Override
        Method[] getDeclaredMethods(Class<?> cls) throws Exception {
            return (Method[])this.getDeclaredMethods.invoke(null, cls);
        }

        @Override
        <T> Constructor<T>[] getDeclaredConstructors(Class<T> cls) throws Exception {
            return (Constructor[])this.getDeclaredConstructors.invoke(null, cls);
        }

        @Override
        Field[] getDeclaredFields(Class<?> cls) throws Exception {
            return (Field[])this.getDeclaredFields.invoke(null, cls);
        }

        @Override
        Object getField(Object object, Field field) throws Exception {
            return this.getField.invoke(null, object, field);
        }

        @Override
        Object getStaticField(Field field) throws Exception {
            return this.getStaticField.invoke(null, field);
        }

        @Override
        Object invokeMethod(Object object, Method method, Object ... args) throws Exception {
            return this.invokeMethod.invoke(null, object, method, args);
        }

        @Override
        Object invokeStaticMethod(Method method, Object ... args) throws Exception {
            return this.invokeStaticMethod.invoke(null, method, args);
        }
    }

    private static class StandardReflectionDriver
    extends ReflectionDriver {
        private StandardReflectionDriver() {
        }

        @Override
        Class<?> findClass(String className) throws Exception {
            return Class.forName(className);
        }

        @Override
        Method[] getDeclaredMethods(Class<?> cls) throws Exception {
            return cls.getDeclaredMethods();
        }

        @Override
        <T> Constructor<T>[] getDeclaredConstructors(Class<T> cls) throws Exception {
            return cls.getDeclaredConstructors();
        }

        @Override
        Field[] getDeclaredFields(Class<?> cls) throws Exception {
            return cls.getDeclaredFields();
        }

        @Override
        boolean makeAccessible(final AccessibleObject obj) {
            if (!obj.isAccessible()) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            obj.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (Throwable e) {
                    try {
                        obj.setAccessible(true);
                    }
                    catch (Throwable e2) {
                        return false;
                    }
                }
            }
            return obj.isAccessible();
        }

        @Override
        Object getField(Object object, Field field) throws Exception {
            this.makeAccessible(field);
            return field.get(object);
        }

        @Override
        Object getStaticField(Field field) throws Exception {
            this.makeAccessible(field);
            return field.get(null);
        }

        @Override
        Object invokeMethod(Object object, Method method, Object ... args) throws Exception {
            this.makeAccessible(method);
            return method.invoke(object, args);
        }

        @Override
        Object invokeStaticMethod(Method method, Object ... args) throws Exception {
            this.makeAccessible(method);
            return method.invoke(null, args);
        }
    }

    private static abstract class ReflectionDriver {
        private ReflectionDriver() {
        }

        abstract Class<?> findClass(String var1) throws Exception;

        abstract Method[] getDeclaredMethods(Class<?> var1) throws Exception;

        abstract <T> Constructor<T>[] getDeclaredConstructors(Class<T> var1) throws Exception;

        abstract Field[] getDeclaredFields(Class<?> var1) throws Exception;

        abstract Object getField(Object var1, Field var2) throws Exception;

        abstract Object getStaticField(Field var1) throws Exception;

        abstract Object invokeMethod(Object var1, Method var2, Object ... var3) throws Exception;

        abstract Object invokeStaticMethod(Method var1, Object ... var2) throws Exception;

        abstract boolean makeAccessible(AccessibleObject var1);

        void forAllMethods(Class<?> cls, MethodIterator methodIter) throws Exception {
            HashSet<GenericDeclaration> visited = new HashSet<GenericDeclaration>();
            LinkedList<GenericDeclaration> interfaceQueue = new LinkedList<GenericDeclaration>();
            for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
                for (Method method : this.getDeclaredMethods(c)) {
                    try {
                        if (!methodIter.foundMethod(method)) continue;
                        return;
                    }
                    catch (IllegalAccessException | SecurityException exception) {
                        // empty catch block
                    }
                }
                if (c.isInterface() && visited.add(c)) {
                    interfaceQueue.add(c);
                }
                for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                    if (!visited.add(genericDeclaration)) continue;
                    interfaceQueue.add(genericDeclaration);
                }
            }
            while (!interfaceQueue.isEmpty()) {
                Class iface = (Class)interfaceQueue.remove();
                for (GenericDeclaration genericDeclaration : this.getDeclaredMethods(iface)) {
                    try {
                        if (!methodIter.foundMethod((Method)genericDeclaration)) continue;
                        return;
                    }
                    catch (IllegalAccessException | SecurityException exception) {
                        // empty catch block
                    }
                }
                for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
                    if (!visited.add(genericDeclaration)) continue;
                    interfaceQueue.add(genericDeclaration);
                }
            }
        }

        Method findMethod(Class<?> cls, final String methodName, final Class<?> ... paramTypes) throws Exception {
            final AtomicReference method = new AtomicReference();
            this.forAllMethods(cls, new MethodIterator(){

                @Override
                public boolean foundMethod(Method m) {
                    if (m.getName().equals(methodName) && Arrays.equals(paramTypes, m.getParameterTypes()) && ReflectionDriver.this.makeAccessible(m)) {
                        method.set(m);
                        return true;
                    }
                    return false;
                }
            });
            Method m = (Method)method.get();
            if (m != null) {
                return m;
            }
            throw new NoSuchMethodException(methodName);
        }

        private static interface MethodIterator {
            public boolean foundMethod(Method var1) throws Exception;
        }
    }
}

