/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.producer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import software.amazon.kinesis.producer.Attempt;
import software.amazon.kinesis.producer.protobuf.Messages;

public class UserRecordResult {
    private List<Attempt> attempts;
    private String sequenceNumber;
    private String shardId;
    private boolean successful;

    public UserRecordResult(List<Attempt> attempts, String sequenceNumber, String shardId, boolean successful) {
        this.attempts = attempts;
        this.sequenceNumber = sequenceNumber;
        this.shardId = shardId;
        this.successful = successful;
    }

    public List<Attempt> getAttempts() {
        return this.attempts;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getShardId() {
        return this.shardId;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    protected static UserRecordResult fromProtobufMessage(Messages.PutRecordResult r) {
        ArrayList<Attempt> attempts = new ArrayList<Attempt>(r.getAttemptsCount());
        for (Messages.Attempt a : r.getAttemptsList()) {
            attempts.add(Attempt.fromProtobufMessage(a));
        }
        return new UserRecordResult((List<Attempt>)new ImmutableList.Builder().addAll(attempts).build(), r.hasSequenceNumber() ? r.getSequenceNumber() : null, r.hasShardId() ? r.getShardId() : null, r.getSuccess());
    }
}

