/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class EnterpriseStreamingEndpoint
implements StreamingEndpoint {
    private static final String BASE_PATH = "/accounts/%s/publishers/twitter/streams/%s/%s.json";
    protected final String account;
    protected final String product;
    protected final String label;
    protected final ConcurrentMap<String, String> queryParameters = Maps.newConcurrentMap();

    public EnterpriseStreamingEndpoint(String account, String product, String label) {
        this(account, product, label, 0);
    }

    public EnterpriseStreamingEndpoint(String account, String product, String label, int clientId) {
        this.account = (String)Preconditions.checkNotNull((Object)account);
        this.product = (String)Preconditions.checkNotNull((Object)product);
        this.label = (String)Preconditions.checkNotNull((Object)label);
        if (clientId > 0) {
            this.addQueryParameter("client", String.valueOf(clientId));
        }
    }

    @Override
    public String getURI() {
        String uri = String.format(BASE_PATH, this.account.trim(), this.product.trim(), this.label.trim());
        if (this.queryParameters.isEmpty()) {
            return uri;
        }
        return uri + "?" + this.generateParamString(this.queryParameters);
    }

    protected String generateParamString(Map<String, String> params) {
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(params);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getPostParamString() {
        return null;
    }

    @Override
    public String getQueryParamString() {
        return this.generateParamString(this.queryParameters);
    }

    @Override
    public void addQueryParameter(String param, String value) {
        this.queryParameters.put(param, value);
    }

    @Override
    public void removeQueryParameter(String param) {
        this.queryParameters.remove(param);
    }

    @Override
    public void setBackfillCount(int count) {
    }

    @Override
    public void setApiVersion(String apiVersion) {
    }

    @Override
    public void addPostParameter(String param, String value) {
    }

    @Override
    public void removePostParameter(String param) {
    }
}

