/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HierarchicalLedgerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HierarchicalLedgerUtils.class);

    static NavigableSet<Long> ledgerListToSet(List<String> ledgerNodes, String ledgerRootPath, String path) {
        char ch;
        TreeSet<Long> zkActiveLedgers = new TreeSet<Long>();
        if (!path.startsWith(ledgerRootPath)) {
            log.warn("Ledger path [{}] is not a valid path name, it should start wth {}", (Object)path, (Object)ledgerRootPath);
            return zkActiveLedgers;
        }
        long ledgerIdPrefix = 0L;
        for (int i = ledgerRootPath.length() + 1; i < path.length(); ++i) {
            ch = path.charAt(i);
            if (ch < '0' || ch > '9') continue;
            ledgerIdPrefix = ledgerIdPrefix * 10L + (long)(ch - 48);
        }
        for (String ledgerNode : ledgerNodes) {
            if (AbstractZkLedgerManager.isSpecialZnode((String)ledgerNode)) continue;
            long ledgerId = ledgerIdPrefix;
            for (int i = 0; i < ledgerNode.length(); ++i) {
                ch = ledgerNode.charAt(i);
                if (ch < '0' || ch > '9') continue;
                ledgerId = ledgerId * 10L + (long)(ch - 48);
            }
            zkActiveLedgers.add(ledgerId);
        }
        return zkActiveLedgers;
    }

    @Generated
    private HierarchicalLedgerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

