/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionTracker;

public final class AsyncScanPartition
extends AsyncMultiCommand {
    private final ScanPolicy scanPolicy;
    private final RecordSequenceListener listener;
    private final String namespace;
    private final String setName;
    private final String[] binNames;
    private final long taskId;
    private final PartitionTracker tracker;
    private final PartitionTracker.NodePartitions nodePartitions;

    public AsyncScanPartition(AsyncMultiExecutor parent, ScanPolicy scanPolicy, RecordSequenceListener listener, String namespace, String setName, String[] binNames, long taskId, PartitionTracker tracker, PartitionTracker.NodePartitions nodePartitions) {
        super(parent, nodePartitions.node, scanPolicy, tracker.socketTimeout, tracker.totalTimeout);
        this.scanPolicy = scanPolicy;
        this.listener = listener;
        this.namespace = namespace;
        this.setName = setName;
        this.binNames = binNames;
        this.taskId = taskId;
        this.tracker = tracker;
        this.nodePartitions = nodePartitions;
    }

    @Override
    protected void writeBuffer() {
        this.setScan(this.scanPolicy, this.namespace, this.setName, this.binNames, this.taskId, this.nodePartitions);
    }

    @Override
    protected void parseRow(Key key) {
        if ((this.info3 & 4) != 0) {
            if (this.resultCode == 0) {
                this.tracker.partitionDone(this.nodePartitions, this.generation);
            }
            return;
        }
        this.tracker.setDigest(this.nodePartitions, key);
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        this.listener.onRecord(key, record);
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        if (this.tracker.shouldRetry(ae)) {
            this.parent.childSuccess(this.node);
            return;
        }
        this.parent.childFailure(ae);
    }
}

