/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CDT;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.ListOrder;
import com.aerospike.client.cdt.ListPolicy;
import com.aerospike.client.util.Packer;
import java.util.List;

public class ListOperation {
    private static final int SET_TYPE = 0;
    private static final int APPEND = 1;
    private static final int APPEND_ITEMS = 2;
    private static final int INSERT = 3;
    private static final int INSERT_ITEMS = 4;
    private static final int POP = 5;
    private static final int POP_RANGE = 6;
    private static final int REMOVE = 7;
    private static final int REMOVE_RANGE = 8;
    private static final int SET = 9;
    private static final int TRIM = 10;
    private static final int CLEAR = 11;
    private static final int INCREMENT = 12;
    private static final int SORT = 13;
    private static final int SIZE = 16;
    private static final int GET = 17;
    private static final int GET_RANGE = 18;
    private static final int GET_BY_INDEX = 19;
    private static final int GET_BY_RANK = 21;
    private static final int GET_BY_VALUE = 22;
    private static final int GET_BY_VALUE_LIST = 23;
    private static final int GET_BY_INDEX_RANGE = 24;
    private static final int GET_BY_VALUE_INTERVAL = 25;
    private static final int GET_BY_RANK_RANGE = 26;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 27;
    private static final int REMOVE_BY_INDEX = 32;
    private static final int REMOVE_BY_RANK = 34;
    private static final int REMOVE_BY_VALUE = 35;
    private static final int REMOVE_BY_VALUE_LIST = 36;
    private static final int REMOVE_BY_INDEX_RANGE = 37;
    private static final int REMOVE_BY_VALUE_INTERVAL = 38;
    private static final int REMOVE_BY_RANK_RANGE = 39;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 40;

    public static Operation create(String binName, ListOrder order, boolean pad, CTX ... ctx) {
        if (ctx == null || ctx.length == 0) {
            return ListOperation.setOrder(binName, order, new CTX[0]);
        }
        Packer packer = new Packer();
        CDT.init(packer, ctx, 0, 1, order.getFlag(pad));
        packer.packInt(order.attributes);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation setOrder(String binName, ListOrder order, CTX ... ctx) {
        return CDT.createOperation(0, Operation.Type.CDT_MODIFY, binName, ctx, order.attributes);
    }

    public static Operation append(String binName, Value value, CTX ... ctx) {
        Packer packer = new Packer();
        CDT.init(packer, ctx, 1, 1);
        value.pack(packer);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation append(ListPolicy policy, String binName, Value value, CTX ... ctx) {
        Packer packer = new Packer();
        CDT.init(packer, ctx, 1, 3);
        value.pack(packer);
        packer.packInt(policy.attributes);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation appendItems(String binName, List<Value> list, CTX ... ctx) {
        Packer packer = new Packer();
        CDT.init(packer, ctx, 2, 1);
        packer.packValueList(list);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation appendItems(ListPolicy policy, String binName, List<Value> list, CTX ... ctx) {
        Packer packer = new Packer();
        CDT.init(packer, ctx, 2, 3);
        packer.packValueList(list);
        packer.packInt(policy.attributes);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation insert(String binName, int index2, Value value, CTX ... ctx) {
        return CDT.createOperation(3, Operation.Type.CDT_MODIFY, binName, ctx, index2, value);
    }

    public static Operation insert(ListPolicy policy, String binName, int index2, Value value, CTX ... ctx) {
        return CDT.createOperation(3, Operation.Type.CDT_MODIFY, binName, ctx, index2, value, policy.flags);
    }

    public static Operation insertItems(String binName, int index2, List<Value> list, CTX ... ctx) {
        Packer packer = new Packer();
        CDT.init(packer, ctx, 4, 2);
        packer.packInt(index2);
        packer.packValueList(list);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation insertItems(ListPolicy policy, String binName, int index2, List<Value> list, CTX ... ctx) {
        Packer packer = new Packer();
        CDT.init(packer, ctx, 4, 3);
        packer.packInt(index2);
        packer.packValueList(list);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation increment(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, ctx, index2);
    }

    public static Operation increment(ListPolicy policy, String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, ctx, index2, Value.get(1), policy.attributes, policy.flags);
    }

    public static Operation increment(String binName, int index2, Value value, CTX ... ctx) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, ctx, index2, value);
    }

    public static Operation increment(ListPolicy policy, String binName, int index2, Value value, CTX ... ctx) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, ctx, index2, value, policy.attributes, policy.flags);
    }

    public static Operation pop(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(5, Operation.Type.CDT_MODIFY, binName, ctx, index2);
    }

    public static Operation popRange(String binName, int index2, int count, CTX ... ctx) {
        return CDT.createOperation(6, Operation.Type.CDT_MODIFY, binName, ctx, index2, count);
    }

    public static Operation popRange(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(6, Operation.Type.CDT_MODIFY, binName, ctx, index2);
    }

    public static Operation remove(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(7, Operation.Type.CDT_MODIFY, binName, ctx, index2);
    }

    public static Operation removeRange(String binName, int index2, int count, CTX ... ctx) {
        return CDT.createOperation(8, Operation.Type.CDT_MODIFY, binName, ctx, index2, count);
    }

    public static Operation removeRange(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(8, Operation.Type.CDT_MODIFY, binName, ctx, index2);
    }

    public static Operation set(String binName, int index2, Value value, CTX ... ctx) {
        return CDT.createOperation(9, Operation.Type.CDT_MODIFY, binName, ctx, index2, value);
    }

    public static Operation set(ListPolicy policy, String binName, int index2, Value value, CTX ... ctx) {
        return CDT.createOperation(9, Operation.Type.CDT_MODIFY, binName, ctx, index2, value, policy.flags);
    }

    public static Operation trim(String binName, int index2, int count, CTX ... ctx) {
        return CDT.createOperation(10, Operation.Type.CDT_MODIFY, binName, ctx, index2, count);
    }

    public static Operation clear(String binName, CTX ... ctx) {
        return CDT.createOperation(11, Operation.Type.CDT_MODIFY, binName, ctx);
    }

    public static Operation sort(String binName, int sortFlags, CTX ... ctx) {
        return CDT.createOperation(13, Operation.Type.CDT_MODIFY, binName, ctx, sortFlags);
    }

    public static Operation removeByValue(String binName, Value value, int returnType, CTX ... ctx) {
        return CDT.createOperation(35, Operation.Type.CDT_MODIFY, binName, ctx, returnType, value);
    }

    public static Operation removeByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        return CDT.createOperation(36, Operation.Type.CDT_MODIFY, binName, ctx, returnType, values);
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        return CDT.createRangeOperation(38, Operation.Type.CDT_MODIFY, binName, ctx, valueBegin, valueEnd, returnType);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(40, Operation.Type.CDT_MODIFY, binName, ctx, returnType, value, rank);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(40, Operation.Type.CDT_MODIFY, binName, ctx, returnType, value, rank, count);
    }

    public static Operation removeByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(32, Operation.Type.CDT_MODIFY, binName, ctx, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(37, Operation.Type.CDT_MODIFY, binName, ctx, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(37, Operation.Type.CDT_MODIFY, binName, ctx, returnType, index2, count);
    }

    public static Operation removeByRank(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(34, Operation.Type.CDT_MODIFY, binName, ctx, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(39, Operation.Type.CDT_MODIFY, binName, ctx, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(39, Operation.Type.CDT_MODIFY, binName, ctx, returnType, rank, count);
    }

    public static Operation size(String binName, CTX ... ctx) {
        return CDT.createOperation(16, Operation.Type.CDT_READ, binName, ctx);
    }

    public static Operation get(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(17, Operation.Type.CDT_READ, binName, ctx, index2);
    }

    public static Operation getRange(String binName, int index2, int count, CTX ... ctx) {
        return CDT.createOperation(18, Operation.Type.CDT_READ, binName, ctx, index2, count);
    }

    public static Operation getRange(String binName, int index2, CTX ... ctx) {
        return CDT.createOperation(18, Operation.Type.CDT_READ, binName, ctx, index2);
    }

    public static Operation getByValue(String binName, Value value, int returnType, CTX ... ctx) {
        return CDT.createOperation(22, Operation.Type.CDT_READ, binName, ctx, returnType, value);
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType, CTX ... ctx) {
        return CDT.createRangeOperation(25, Operation.Type.CDT_READ, binName, ctx, valueBegin, valueEnd, returnType);
    }

    public static Operation getByValueList(String binName, List<Value> values, int returnType, CTX ... ctx) {
        return CDT.createOperation(23, Operation.Type.CDT_READ, binName, ctx, returnType, values);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(27, Operation.Type.CDT_READ, binName, ctx, returnType, value, rank);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(27, Operation.Type.CDT_READ, binName, ctx, returnType, value, rank, count);
    }

    public static Operation getByIndex(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(19, Operation.Type.CDT_READ, binName, ctx, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int returnType, CTX ... ctx) {
        return CDT.createOperation(24, Operation.Type.CDT_READ, binName, ctx, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(24, Operation.Type.CDT_READ, binName, ctx, returnType, index2, count);
    }

    public static Operation getByRank(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(21, Operation.Type.CDT_READ, binName, ctx, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int returnType, CTX ... ctx) {
        return CDT.createOperation(26, Operation.Type.CDT_READ, binName, ctx, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int count, int returnType, CTX ... ctx) {
        return CDT.createOperation(26, Operation.Type.CDT_READ, binName, ctx, returnType, rank, count);
    }
}

