/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.AzureCliCredentialBuilder;
import com.microsoft.azure.kusto.data.auth.CloudDependentTokenProviderBase;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.HttpClientWrapper;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzureCliTokenProvider
extends CloudDependentTokenProviderBase {
    public static final String AZURE_CLI_TOKEN_PROVIDER = "AzureCliTokenProvider";
    private TokenRequestContext tokenRequestContext;
    private AzureCliCredential azureCliCredential;

    public AzureCliTokenProvider(@NotNull String clusterUrl, @Nullable org.apache.http.client.HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
    }

    @Override
    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataServiceException, DataClientException {
        super.initializeWithCloudInfo(cloudInfo);
        AzureCliCredentialBuilder builder = new AzureCliCredentialBuilder();
        if (this.httpClient != null) {
            builder = (AzureCliCredentialBuilder)builder.httpClient((HttpClient)new HttpClientWrapper(this.httpClient));
        }
        this.azureCliCredential = builder.build();
        this.tokenRequestContext = new TokenRequestContext().addScopes(this.scopes.toArray(new String[0]));
    }

    @Override
    protected String acquireAccessTokenImpl() throws DataServiceException {
        AccessToken accessToken = (AccessToken)this.azureCliCredential.getToken(this.tokenRequestContext).block();
        if (accessToken == null) {
            throw new DataServiceException(this.clusterUrl, "Couldn't get token from Azure Identity", true);
        }
        return accessToken.getToken();
    }

    @Override
    protected String getAuthMethod() {
        return AZURE_CLI_TOKEN_PROVIDER;
    }
}

