/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.azure.kusto.data.auth.CallbackTokenProviderFunction;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallbackTokenProvider
extends TokenProviderBase {
    public static final String CALLBACK_TOKEN_PROVIDER = "CallbackTokenProvider";
    private final CallbackTokenProviderFunction tokenProvider;

    CallbackTokenProvider(@NotNull String clusterUrl, @NotNull Callable<String> tokenProvider) throws URISyntaxException {
        super(clusterUrl, null);
        this.tokenProvider = httpClient -> (String)tokenProvider.call();
    }

    CallbackTokenProvider(@NotNull String clusterUrl, @NotNull CallbackTokenProviderFunction tokenProvider, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
        this.tokenProvider = tokenProvider;
    }

    @Override
    protected String acquireAccessTokenImpl() throws DataClientException {
        try {
            return this.tokenProvider.apply(this.httpClient);
        }
        catch (Exception e) {
            throw new DataClientException(this.clusterUrl, e.getMessage(), e);
        }
    }

    @Override
    protected String getAuthMethod() {
        return CALLBACK_TOKEN_PROVIDER;
    }
}

