/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IConfidentialClientApplication;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.MsalTokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfidentialAppTokenProviderBase
extends MsalTokenProviderBase {
    final String applicationClientId;
    IConfidentialClientApplication clientApplication;

    ConfidentialAppTokenProviderBase(@NotNull String clusterUrl, @NotNull String applicationClientId, String authorityId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, authorityId, httpClient);
        this.applicationClientId = applicationClientId;
    }

    @Override
    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataClientException, DataServiceException {
        super.initializeWithCloudInfo(cloudInfo);
        try {
            this.clientApplication = this.getClientApplication();
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, "Error acquiring ApplicationAccessToken due to invalid Authority URL", e);
        }
    }

    @Override
    protected IAuthenticationResult acquireNewAccessToken() throws DataServiceException {
        IAuthenticationResult result;
        try {
            CompletableFuture future = this.clientApplication.acquireToken(ClientCredentialParameters.builder((Set)this.scopes).build());
            result = (IAuthenticationResult)future.get(20000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new DataServiceException(this.clusterUrl, "Error acquiring ApplicationAccessToken", e, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DataServiceException(this.clusterUrl, "Error acquiring ApplicationAccessToken", e, false);
        }
        if (result == null) {
            throw new DataServiceException(this.clusterUrl, "acquireNewAccessToken got 'null' authentication result", false);
        }
        return result;
    }

    @Override
    protected IAuthenticationResult acquireAccessTokenSilentlyMsal() throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture accounts = this.clientApplication.getAccounts();
        return (IAuthenticationResult)this.clientApplication.acquireTokenSilently(this.getSilentParameters((Set)accounts.join())).get(20000L, TimeUnit.MILLISECONDS);
    }

    protected abstract IConfidentialClientApplication getClientApplication() throws MalformedURLException;
}

