/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.microsoft.azure.kusto.ingest.IngestionProperties;
import com.microsoft.azure.kusto.ingest.result.IngestionStatusInTableDescription;
import com.microsoft.azure.kusto.ingest.result.ValidationPolicy;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.UUID;

public final class IngestionBlobInfo {
    private final String blobPath;
    private Long rawDataSize;
    private final String databaseName;
    private final String tableName;
    private UUID id;
    private final Boolean retainBlobOnSuccess;
    private String reportLevel;
    private String reportMethod;
    private String sourceMessageCreationTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ValidationPolicy validationPolicy;
    private Boolean flushImmediately;
    private IngestionStatusInTableDescription ingestionStatusInTable;
    private Map<String, String> additionalProperties;
    private String applicationForTracing;
    private String clientVersionForTracing;

    public IngestionBlobInfo(String blobPath, String databaseName, String tableName, String applicationForTracing, String clientVersionForTracing) {
        this.blobPath = blobPath;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.id = UUID.randomUUID();
        this.retainBlobOnSuccess = true;
        this.reportLevel = IngestionProperties.IngestionReportLevel.FAILURES_ONLY.getKustoValue();
        this.reportMethod = IngestionProperties.IngestionReportMethod.QUEUE.getKustoValue();
        this.flushImmediately = false;
        this.sourceMessageCreationTime = LocalDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).toString();
        this.applicationForTracing = applicationForTracing;
        this.clientVersionForTracing = clientVersionForTracing;
    }

    public String getBlobPath() {
        return this.blobPath;
    }

    public Long getRawDataSize() {
        return this.rawDataSize;
    }

    public void setRawDataSize(Long rawDataSize) {
        this.rawDataSize = rawDataSize;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Boolean getRetainBlobOnSuccess() {
        return this.retainBlobOnSuccess;
    }

    public String getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(String reportLevel) {
        this.reportLevel = reportLevel;
    }

    public String getReportMethod() {
        return this.reportMethod;
    }

    public void setReportMethod(String reportMethod) {
        this.reportMethod = reportMethod;
    }

    public String getSourceMessageCreationTime() {
        return this.sourceMessageCreationTime;
    }

    public void setSourceMessageCreationTime(String sourceMessageCreationTime) {
        this.sourceMessageCreationTime = sourceMessageCreationTime;
    }

    public Boolean getFlushImmediately() {
        return this.flushImmediately;
    }

    public void setFlushImmediately(boolean flushImmediately) {
        this.flushImmediately = flushImmediately;
    }

    public IngestionStatusInTableDescription getIngestionStatusInTable() {
        return this.ingestionStatusInTable;
    }

    public void setIngestionStatusInTable(IngestionStatusInTableDescription ingestionStatusInTable) {
        this.ingestionStatusInTable = ingestionStatusInTable;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public ValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public String getApplicationForTracing() {
        return this.applicationForTracing;
    }

    public String getClientVersionForTracing() {
        return this.clientVersionForTracing;
    }
}

