/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.result;

import com.azure.data.tables.models.TableEntity;
import com.microsoft.azure.kusto.ingest.result.IngestionErrorCode;
import com.microsoft.azure.kusto.ingest.result.IngestionFailureInfo;
import com.microsoft.azure.kusto.ingest.result.OperationStatus;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class IngestionStatus {
    public OperationStatus status;
    private Map<String, Object> ingestionInfo = new HashMap<String, Object>();
    public UUID ingestionSourceId;
    public String ingestionSourcePath;
    public String database;
    public String table;
    public Instant updatedOn;
    public UUID operationId;
    public UUID activityId;
    public String errorCodeString;
    public IngestionErrorCode errorCode;
    public IngestionFailureInfo.FailureStatusValue failureStatus;
    public String details;
    public boolean originatesFromUpdatePolicy;

    public String getStatus() {
        return this.status.toString();
    }

    public void setStatus(String s) {
        if (s != null) {
            this.setStatus(OperationStatus.valueOf(s));
        }
    }

    public void setStatus(OperationStatus st) {
        this.status = st;
        this.ingestionInfo.put("Status", (Object)st);
    }

    public UUID getIngestionSourceId() {
        return this.ingestionSourceId;
    }

    public void setIngestionSourceId(UUID id) {
        this.ingestionSourceId = id;
        this.ingestionInfo.put("IngestionSourceId", id);
    }

    public String getIngestionSourcePath() {
        return this.ingestionSourcePath;
    }

    public void setIngestionSourcePath(String path) {
        this.ingestionSourcePath = path;
        this.ingestionInfo.put("IngestionSourcePath", this.ingestionSourcePath);
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String db) {
        this.database = db;
        this.ingestionInfo.put("Database", this.database);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String t) {
        this.table = t;
        this.ingestionInfo.put("Table", this.table);
    }

    public Instant getUpdatedOn() {
        return this.updatedOn;
    }

    public void setUpdatedOn(Instant lastUpdated) {
        this.updatedOn = lastUpdated;
        this.ingestionInfo.put("UpdatedOn", this.updatedOn);
    }

    public UUID getOperationId() {
        return this.operationId;
    }

    public void setOperationId(UUID id) {
        this.operationId = id;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public void setActivityId(UUID id) {
        this.activityId = id;
    }

    public String getErrorCode() {
        return this.errorCodeString;
    }

    public void setErrorCode(String code) {
        this.errorCodeString = code;
        try {
            this.errorCode = code == null ? IngestionErrorCode.Unknown : IngestionErrorCode.valueOf(code);
        }
        catch (IllegalArgumentException ex) {
            this.errorCode = IngestionErrorCode.Misc;
        }
    }

    public String getFailureStatus() {
        return (this.failureStatus != null ? this.failureStatus : IngestionFailureInfo.FailureStatusValue.Unknown).toString();
    }

    public void setFailureStatus(String status) {
        if (status != null) {
            this.failureStatus = IngestionFailureInfo.FailureStatusValue.valueOf(status);
        }
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String d) {
        this.details = d;
    }

    public boolean getOriginatesFromUpdatePolicy() {
        return this.originatesFromUpdatePolicy;
    }

    public void setOriginatesFromUpdatePolicy(boolean fromUpdatePolicy) {
        this.originatesFromUpdatePolicy = fromUpdatePolicy;
    }

    public Map<String, Object> getEntityProperties() {
        return this.ingestionInfo;
    }

    public static IngestionStatus fromEntity(TableEntity tableEntity) {
        IngestionStatus ingestionStatus = new IngestionStatus();
        Object ingestionSourceId = tableEntity.getProperty("IngestionSourceId");
        ingestionStatus.setIngestionSourceId(ingestionSourceId == null ? null : (UUID)ingestionSourceId);
        ingestionStatus.setDatabase((String)tableEntity.getProperty("Database"));
        ingestionStatus.setTable((String)tableEntity.getProperty("Table"));
        Object operationId = tableEntity.getProperty("OperationId");
        ingestionStatus.setOperationId(ingestionSourceId == null ? null : (UUID)operationId);
        Object status = tableEntity.getProperty("Status");
        if (status instanceof String) {
            ingestionStatus.setStatus((String)status);
        } else {
            ingestionStatus.setStatus((OperationStatus)((Object)status));
        }
        Object activityId = tableEntity.getProperty("ActivityId");
        ingestionStatus.setActivityId(ingestionSourceId == null ? null : (UUID)activityId);
        ingestionStatus.setFailureStatus((String)tableEntity.getProperty("FailureStatus"));
        Object originatesFromUpdatePolicy = tableEntity.getProperty("OriginatesFromUpdatePolicy");
        ingestionStatus.setOriginatesFromUpdatePolicy(originatesFromUpdatePolicy != null && (Boolean)originatesFromUpdatePolicy != false);
        ingestionStatus.setIngestionSourcePath((String)tableEntity.getProperty("IngestionSourcePath"));
        Object errorCode = tableEntity.getProperty("ErrorCode");
        if (errorCode != null) {
            ingestionStatus.setErrorCode((String)errorCode);
        }
        ingestionStatus.setDetails((String)tableEntity.getProperty("Details"));
        Object updatedOn = tableEntity.getProperty("UpdatedOn");
        if (updatedOn instanceof OffsetDateTime) {
            ingestionStatus.setUpdatedOn(((OffsetDateTime)updatedOn).toInstant());
        } else {
            ingestionStatus.setUpdatedOn((Instant)updatedOn);
        }
        return ingestionStatus;
    }
}

