/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.result;

import com.azure.data.tables.TableClient;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.models.TableEntity;
import com.microsoft.azure.kusto.ingest.result.IngestionResult;
import com.microsoft.azure.kusto.ingest.result.IngestionStatus;
import com.microsoft.azure.kusto.ingest.result.IngestionStatusInTableDescription;
import java.util.LinkedList;
import java.util.List;

public class TableReportIngestionResult
implements IngestionResult {
    private final List<IngestionStatusInTableDescription> descriptors;

    public TableReportIngestionResult(List<IngestionStatusInTableDescription> descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public List<IngestionStatus> getIngestionStatusCollection() throws TableServiceErrorException {
        LinkedList<IngestionStatus> results = new LinkedList<IngestionStatus>();
        for (IngestionStatusInTableDescription descriptor : this.descriptors) {
            TableClient table = descriptor.getTableClient();
            TableEntity entity = table.getEntity(descriptor.getPartitionKey(), descriptor.getRowKey());
            results.add(IngestionStatus.fromEntity(entity));
        }
        return results;
    }

    @Override
    public int getIngestionStatusesLength() {
        return this.descriptors.size();
    }
}

