/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.implementation.TableUtils;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class TableAzureNamedKeyCredentialPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_HEADER_FORMAT = "SharedKeyLite %s:%s";
    private final AzureNamedKeyCredential credential;

    public TableAzureNamedKeyCredentialPolicy(AzureNamedKeyCredential credential) {
        this.credential = credential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String authorizationValue = this.generateAuthorizationHeader(context.getHttpRequest().getUrl(), context.getHttpRequest().getHeaders());
        context.getHttpRequest().setHeader("Authorization", authorizationValue);
        return next.process();
    }

    String generateAuthorizationHeader(URL requestUrl, HttpHeaders headers) {
        String signature = TableSasUtils.computeHmac256(this.credential.getAzureNamedKey().getKey(), TableAzureNamedKeyCredentialPolicy.buildStringToSign(requestUrl, headers, this.credential));
        return String.format(AUTHORIZATION_HEADER_FORMAT, this.credential.getAzureNamedKey().getName(), signature);
    }

    private static String buildStringToSign(URL requestUrl, HttpHeaders headers, AzureNamedKeyCredential credential) {
        String dateHeader = headers.get("x-ms-date") != null ? "" : TableAzureNamedKeyCredentialPolicy.getStandardHeaderValue(headers, "Date");
        return String.join((CharSequence)"\n", dateHeader, TableAzureNamedKeyCredentialPolicy.getCanonicalizedResource(requestUrl, credential));
    }

    private static String getStandardHeaderValue(HttpHeaders headers, String headerName) {
        HttpHeader header = headers.get(headerName);
        return header == null ? "" : header.getValue();
    }

    private static String getCanonicalizedResource(URL requestUrl, AzureNamedKeyCredential credential) {
        Map<String, String[]> queryParams;
        Object[] queryParamValues;
        StringBuilder canonicalizedResource = new StringBuilder("/").append(credential.getAzureNamedKey().getName());
        if (requestUrl.getPath().length() > 0) {
            canonicalizedResource.append(requestUrl.getPath());
        } else {
            canonicalizedResource.append('/');
        }
        if (requestUrl.getQuery() != null && (queryParamValues = (queryParams = TableUtils.parseQueryStringSplitValues(requestUrl.getQuery())).get("comp")) != null) {
            Arrays.sort(queryParamValues);
            canonicalizedResource.append("?comp=").append(String.join((CharSequence)",", (CharSequence[])queryParamValues));
        }
        return canonicalizedResource.toString();
    }

    public AzureNamedKeyCredential getCredential() {
        return this.credential;
    }
}

