/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.implementation.models.CorsRule;
import com.azure.data.tables.implementation.models.Logging;
import com.azure.data.tables.implementation.models.Metrics;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceProperties
implements XmlSerializable<TableServiceProperties> {
    private Logging logging;
    private Metrics hourMetrics;
    private Metrics minuteMetrics;
    private List<CorsRule> cors;

    public Logging getLogging() {
        return this.logging;
    }

    public TableServiceProperties setLogging(Logging logging) {
        this.logging = logging;
        return this;
    }

    public Metrics getHourMetrics() {
        return this.hourMetrics;
    }

    public TableServiceProperties setHourMetrics(Metrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    public Metrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    public TableServiceProperties setMinuteMetrics(Metrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    public List<CorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new ArrayList<CorsRule>();
        }
        return this.cors;
    }

    public TableServiceProperties setCors(List<CorsRule> cors) {
        this.cors = cors;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.logging, "Logging");
        xmlWriter.writeXml((XmlSerializable)this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml((XmlSerializable)this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (CorsRule element : this.cors) {
                xmlWriter.writeXml((XmlSerializable)element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static TableServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceProperties.fromXml(xmlReader, null);
    }

    public static TableServiceProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceProperties" : rootElementName;
        return (TableServiceProperties)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceProperties deserializedTableServiceProperties = new TableServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Logging".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.logging = Logging.fromXml(reader, "Logging");
                    continue;
                }
                if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.hourMetrics = Metrics.fromXml(reader, "HourMetrics");
                    continue;
                }
                if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedTableServiceProperties.minuteMetrics = Metrics.fromXml(reader, "MinuteMetrics");
                    continue;
                }
                if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedTableServiceProperties.cors == null) {
                                deserializedTableServiceProperties.cors = new ArrayList<CorsRule>();
                            }
                            deserializedTableServiceProperties.cors.add(CorsRule.fromXml(reader, "CorsRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceProperties;
        });
    }
}

