/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.Immutable;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.util.Collect;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.util.Set;

public class OracleErrorHandler
extends ErrorHandler {
    @Immutable
    private static final Set<String> RETRIABLE_ERROR_CODES = Collect.unmodifiableSet((Object[])new String[]{"ORA-03135", "ORA-12543", "ORA-00604", "ORA-01089", "ORA-01333", "ORA-01284", "ORA-26653", "ORA-01291", "ORA-01327", "ORA-04030", "ORA-00310", "ORA-01343", "ORA-01371"});
    @Immutable
    private static final Set<String> RETRIABLE_ERROR_MESSAGES = Collect.unmodifiableSet((Object[])new String[]{"No more data to read from socket"});

    public OracleErrorHandler(OracleConnectorConfig connectorConfig, ChangeEventQueue<?> queue) {
        super(OracleConnector.class, (CommonConnectorConfig)connectorConfig, queue);
    }

    protected boolean isRetriable(Throwable throwable) {
        while (throwable != null) {
            Throwable cause;
            if (throwable instanceof SQLRecoverableException) {
                return true;
            }
            String message = throwable.getMessage();
            if (message != null && message.length() > 0) {
                for (String errorCode : RETRIABLE_ERROR_CODES) {
                    if (!message.startsWith(errorCode)) continue;
                    return true;
                }
                for (String messageText : RETRIABLE_ERROR_MESSAGES) {
                    if (!message.toUpperCase().contains(messageText.toUpperCase())) continue;
                    return true;
                }
            }
            if (throwable.getCause() != null && (cause = throwable.getCause()) instanceof IOException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

