/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.get;

import java.io.IOException;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.RealtimeRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.index.VersionType;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

@PublicApi(since="1.0.0")
public class GetRequest
extends SingleShardRequest<GetRequest>
implements RealtimeRequest {
    private String id;
    private String routing;
    private String preference;
    private String[] storedFields;
    private FetchSourceContext fetchSourceContext;
    private boolean refresh = false;
    boolean realtime = true;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;

    public GetRequest() {
    }

    GetRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readString();
        }
        this.id = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before((Version)LegacyESVersion.V_7_0_0)) {
            in.readOptionalString();
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.storedFields = in.readOptionalStringArray();
        this.realtime = in.readBoolean();
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = in.readLong();
        this.fetchSourceContext = (FetchSourceContext)in.readOptionalWriteable(FetchSourceContext::new);
    }

    public GetRequest(String index) {
        super(index);
    }

    public GetRequest(String index, String id) {
        super(index);
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validateNonNullIndex();
        if (Strings.isEmpty((CharSequence)this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForReads(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    public GetRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public GetRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    public GetRequest storedFields(String ... fields) {
        this.storedFields = fields;
        return this;
    }

    public String[] storedFields() {
        return this.storedFields;
    }

    public GetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public GetRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public long version() {
        return this.version;
    }

    public GetRequest version(long version) {
        this.version = version;
        return this;
    }

    public GetRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        if (out.getVersion().before((Version)LegacyESVersion.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeOptionalStringArray(this.storedFields);
        out.writeBoolean(this.realtime);
        out.writeByte(this.versionType.getValue());
        out.writeLong(this.version);
        out.writeOptionalWriteable((Writeable)this.fetchSourceContext);
    }

    public String toString() {
        return "get [" + this.index + "][" + this.id + "]: routing [" + this.routing + "]";
    }
}

