/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.util.function.Supplier;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;

public final class ContextPreservingActionListener<R>
implements ActionListener<R> {
    private final ActionListener<R> delegate;
    private final Supplier<ThreadContext.StoredContext> context;

    public ContextPreservingActionListener(Supplier<ThreadContext.StoredContext> contextSupplier, ActionListener<R> delegate) {
        this.delegate = delegate;
        this.context = contextSupplier;
    }

    public void onResponse(R r) {
        try (ThreadContext.StoredContext ignore = this.context.get();){
            this.delegate.onResponse(r);
        }
    }

    public void onFailure(Exception e) {
        try (ThreadContext.StoredContext ignore = this.context.get();){
            this.delegate.onFailure(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "/" + this.delegate.toString();
    }

    public static <R> ContextPreservingActionListener<R> wrapPreservingContext(ActionListener<R> listener, ThreadContext threadContext) {
        return new ContextPreservingActionListener<R>(threadContext.newRestorableContext(true), listener);
    }
}

