/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.clustermanager.term;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.action.support.clustermanager.term.GetTermVersionRequest;
import org.opensearch.action.support.clustermanager.term.GetTermVersionResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.coordination.ClusterStateTermVersion;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetTermVersionAction
extends TransportClusterManagerNodeReadAction<GetTermVersionRequest, GetTermVersionResponse> {
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Inject
    public TransportGetTermVersionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:monitor/term", false, transportService, clusterService, threadPool, actionFilters, GetTermVersionRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    public GetTermVersionResponse read(StreamInput in) throws IOException {
        return new GetTermVersionResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetTermVersionRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void clusterManagerOperation(GetTermVersionRequest request, ClusterState state, ActionListener<GetTermVersionResponse> listener) throws Exception {
        ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
    }

    private GetTermVersionResponse buildResponse(GetTermVersionRequest request, ClusterState state) {
        return new GetTermVersionResponse(new ClusterStateTermVersion(state));
    }
}

