/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.document;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.LongHashSet;
import org.opensearch.index.document.SortedUnsignedLongDocValuesRangeQuery;

public abstract class SortedUnsignedLongDocValuesSetQuery
extends Query {
    private final String field;
    private final LongHashSet numbers;

    SortedUnsignedLongDocValuesSetQuery(String field, BigInteger[] numbers) {
        this.field = Objects.requireNonNull(field);
        Arrays.sort(numbers);
        this.numbers = new LongHashSet(Arrays.stream(numbers).mapToLong(n -> n.longValue()).toArray());
    }

    public String toString(String field) {
        return field + ": " + this.numbers.toString();
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.numbers.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        SortedUnsignedLongDocValuesSetQuery that = (SortedUnsignedLongDocValuesSetQuery)((Object)other);
        return this.field.equals(that.field) && this.numbers.equals(that.numbers);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.numbers);
    }

    abstract SortedNumericDocValues getValues(LeafReader var1, String var2) throws IOException;

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{SortedUnsignedLongDocValuesSetQuery.this.field});
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = SortedUnsignedLongDocValuesSetQuery.this.getValues(context.reader(), SortedUnsignedLongDocValuesSetQuery.this.field);
                if (values == null) {
                    return null;
                }
                final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator((DocIdSetIterator)singleton){

                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return Long.compareUnsigned(value, SortedUnsignedLongDocValuesSetQuery.this.numbers.minValue) >= 0 && Long.compareUnsigned(value, SortedUnsignedLongDocValuesSetQuery.this.numbers.maxValue) <= 0 && SortedUnsignedLongDocValuesSetQuery.this.numbers.contains(value);
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (Long.compareUnsigned(value, SortedUnsignedLongDocValuesSetQuery.this.numbers.minValue) < 0) continue;
                            if (Long.compareUnsigned(value, SortedUnsignedLongDocValuesSetQuery.this.numbers.maxValue) > 0) {
                                return false;
                            }
                            if (!SortedUnsignedLongDocValuesSetQuery.this.numbers.contains(value)) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }
        };
    }

    public static Query newSlowSetQuery(String field, BigInteger ... values) {
        return new SortedUnsignedLongDocValuesSetQuery(field, values){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric((LeafReader)reader, (String)field);
            }
        };
    }

    public static Query newSlowExactQuery(String field, BigInteger value) {
        return new SortedUnsignedLongDocValuesRangeQuery(field, value, value){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric((LeafReader)reader, (String)field);
            }
        };
    }
}

