/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.tiering;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.tiering.TieringValidationResult;
import org.opensearch.cluster.ClusterInfo;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexModule;

public class TieringRequestValidator {
    private static final Logger logger = LogManager.getLogger(TieringRequestValidator.class);

    public static TieringValidationResult validateHotToWarm(ClusterState currentState, Set<Index> concreteIndices, ClusterInfo clusterInfo, DiskThresholdSettings diskThresholdSettings) {
        String indexNames = concreteIndices.stream().map(Index::getName).collect(Collectors.joining(", "));
        TieringRequestValidator.validateSearchNodes(currentState, indexNames);
        TieringRequestValidator.validateDiskThresholdWaterMarkNotBreached(currentState, clusterInfo, diskThresholdSettings, indexNames);
        TieringValidationResult tieringValidationResult = new TieringValidationResult(concreteIndices);
        for (Index index : concreteIndices) {
            if (!TieringRequestValidator.validateHotIndex(currentState, index)) {
                tieringValidationResult.addToRejected(index, "index is not in the HOT tier");
                continue;
            }
            if (!TieringRequestValidator.validateRemoteStoreIndex(currentState, index)) {
                tieringValidationResult.addToRejected(index, "index is not backed up by the remote store");
                continue;
            }
            if (!TieringRequestValidator.validateOpenIndex(currentState, index)) {
                tieringValidationResult.addToRejected(index, "index is closed");
                continue;
            }
            if (TieringRequestValidator.validateIndexHealth(currentState, index)) continue;
            tieringValidationResult.addToRejected(index, "index is red");
        }
        TieringRequestValidator.validateEligibleNodesCapacity(clusterInfo, currentState, tieringValidationResult);
        logger.info("Successfully accepted indices for tiering are [{}], rejected indices are [{}]", tieringValidationResult.getAcceptedIndices(), tieringValidationResult.getRejectedIndices());
        return tieringValidationResult;
    }

    static void validateSearchNodes(ClusterState currentState, String indexNames) {
        if (TieringRequestValidator.getEligibleNodes(currentState).isEmpty()) {
            String errorMsg = "Rejecting tiering request for indices [" + indexNames + "] because there are no nodes found with the search role";
            logger.warn(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
    }

    static boolean validateRemoteStoreIndex(ClusterState state, Index index) {
        return IndexMetadata.INDEX_REMOTE_STORE_ENABLED_SETTING.get(state.metadata().getIndexSafe(index).getSettings());
    }

    static boolean validateHotIndex(ClusterState state, Index index) {
        return IndexModule.TieringState.HOT.name().equals(IndexModule.INDEX_TIERING_STATE.get(state.metadata().getIndexSafe(index).getSettings()));
    }

    static boolean validateIndexHealth(ClusterState currentState, Index index) {
        IndexRoutingTable indexRoutingTable = currentState.routingTable().index(index);
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetadata, indexRoutingTable);
        return !ClusterHealthStatus.RED.equals((Object)indexHealth.getStatus());
    }

    static boolean validateOpenIndex(ClusterState currentState, Index index) {
        return currentState.metadata().index(index).getState() == IndexMetadata.State.OPEN;
    }

    static void validateDiskThresholdWaterMarkNotBreached(ClusterState currentState, ClusterInfo clusterInfo, DiskThresholdSettings diskThresholdSettings, String indexNames) {
        Map<String, DiskUsage> usages = clusterInfo.getNodeLeastAvailableDiskUsages();
        if (usages == null) {
            logger.trace("skipping monitor as no disk usage information is available");
            return;
        }
        Set nodeIds = TieringRequestValidator.getEligibleNodes(currentState).stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        for (String node : nodeIds) {
            DiskUsage nodeUsage = usages.get(node);
            if (nodeUsage == null || nodeUsage.getFreeBytes() <= diskThresholdSettings.getFreeBytesThresholdLow().getBytes()) continue;
            return;
        }
        throw new IllegalArgumentException("Disk threshold low watermark is breached on all the search nodes, rejecting tiering request for indices: " + indexNames);
    }

    static void validateEligibleNodesCapacity(ClusterInfo clusterInfo, ClusterState currentState, TieringValidationResult tieringValidationResult) {
        Set<String> eligibleNodeIds = TieringRequestValidator.getEligibleNodes(currentState).stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        long totalAvailableBytesInWarmTier = TieringRequestValidator.getTotalAvailableBytesInWarmTier(clusterInfo.getNodeLeastAvailableDiskUsages(), eligibleNodeIds);
        HashMap<Index, Long> indexSizes = new HashMap<Index, Long>();
        for (Index index : tieringValidationResult.getAcceptedIndices()) {
            indexSizes.put(index, TieringRequestValidator.getIndexPrimaryStoreSize(currentState, clusterInfo, index.getName()));
        }
        if (indexSizes.values().stream().mapToLong(Long::longValue).sum() < totalAvailableBytesInWarmTier) {
            return;
        }
        HashMap sortedIndexSizes = indexSizes.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, HashMap::new));
        long requestIndexBytes = 0L;
        for (Index index : sortedIndexSizes.keySet()) {
            if ((requestIndexBytes += ((Long)sortedIndexSizes.get(index)).longValue()) < totalAvailableBytesInWarmTier) continue;
            tieringValidationResult.addToRejected(index, "insufficient node capacity");
        }
    }

    static long getIndexPrimaryStoreSize(ClusterState clusterState, ClusterInfo clusterInfo, String index) {
        long totalIndexSize = 0L;
        List<ShardRouting> shardRoutings = clusterState.routingTable().allShards(index);
        for (ShardRouting shardRouting : shardRoutings) {
            if (!shardRouting.primary()) continue;
            totalIndexSize += clusterInfo.getShardSize(shardRouting, 0L);
        }
        return totalIndexSize;
    }

    static long getTotalAvailableBytesInWarmTier(Map<String, DiskUsage> usages, Set<String> nodeIds) {
        long totalAvailableBytes = 0L;
        for (String node : nodeIds) {
            totalAvailableBytes += usages.get(node).getFreeBytes();
        }
        return totalAvailableBytes;
    }

    static Set<DiscoveryNode> getEligibleNodes(ClusterState currentState) {
        Map<String, DiscoveryNode> nodes = currentState.getNodes().getDataNodes();
        return nodes.values().stream().filter(DiscoveryNode::isSearchNode).collect(Collectors.toSet());
    }
}

