/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.Client;
import com.sproutsocial.nsq.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

class BasePubSub {
    protected Config config = new Config();
    protected volatile boolean isStopping = false;
    protected final Client client;
    private final List<ScheduledFuture> tasks = Collections.synchronizedList(new ArrayList());

    protected BasePubSub(Client client) {
        this.client = client;
    }

    public final Client getClient() {
        return this.client;
    }

    public synchronized Config getConfig() {
        return this.config;
    }

    public synchronized void setConfig(Config config) {
        this.config = config;
    }

    protected void scheduleAtFixedRate(Runnable runnable, int initialDelay, int period, boolean jitter) {
        if (!this.isStopping) {
            this.tasks.add(this.client.scheduleAtFixedRate(runnable, initialDelay, period, jitter));
        }
    }

    public void stop() {
        this.isStopping = true;
        this.cancelTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTasks() {
        List<ScheduledFuture> list = this.tasks;
        synchronized (list) {
            for (ScheduledFuture task : this.tasks) {
                task.cancel(false);
            }
            this.tasks.clear();
        }
    }
}

