/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.azure.core.util.BinaryData;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.models.TableEntity;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.models.QueueStorageException;
import com.microsoft.azure.kusto.data.Ensure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureStorageClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int GZIP_BUFFER_SIZE = 16384;
    private static final int STREAM_BUFFER_SIZE = 16384;

    void postMessageToQueue(QueueClient queueClient, String content) throws QueueStorageException {
        Ensure.argIsNotNull((Object)queueClient, (String)"queueClient");
        Ensure.stringIsNotBlank((String)content, (String)"content");
        byte[] bytesEncoded = Base64.encodeBase64((byte[])content.getBytes());
        queueClient.sendMessage(BinaryData.fromBytes((byte[])bytesEncoded));
    }

    public void azureTableInsertEntity(TableClient tableClient, TableEntity tableEntity) throws URISyntaxException, TableServiceErrorException {
        Ensure.argIsNotNull((Object)tableClient, (String)"tableClient");
        Ensure.argIsNotNull((Object)tableEntity, (String)"tableEntity");
        tableClient.createEntity(tableEntity);
    }

    void uploadLocalFileToBlob(File file, String blobName, BlobContainerClient container, boolean shouldCompress) throws IOException, BlobStorageException {
        log.debug("uploadLocalFileToBlob: filePath: {}, blobName: {}, storageUri: {}", new Object[]{file.getPath(), blobName, container.getBlobContainerUrl()});
        Ensure.fileExists((File)file, (String)"sourceFile");
        Ensure.stringIsNotBlank((String)blobName, (String)"blobName");
        Ensure.argIsNotNull((Object)container, (String)"container");
        BlobClient blobClient = container.getBlobClient(blobName);
        if (shouldCompress) {
            this.compressAndUploadFileToBlob(file, blobClient);
        } else {
            this.uploadFileToBlob(file, blobClient);
        }
    }

    void compressAndUploadFileToBlob(File sourceFile, BlobClient blob) throws IOException, BlobStorageException {
        Ensure.fileExists((File)sourceFile, (String)"sourceFile");
        Ensure.argIsNotNull((Object)blob, (String)"blob");
        try (InputStream fin = Files.newInputStream(sourceFile.toPath(), new OpenOption[0]);
             GZIPOutputStream gzOut = new GZIPOutputStream((OutputStream)blob.getBlockBlobClient().getBlobOutputStream(true));){
            this.copyStream(fin, gzOut, 16384);
        }
    }

    void uploadFileToBlob(File sourceFile, BlobClient blobClient) throws IOException, BlobStorageException {
        Ensure.argIsNotNull((Object)blobClient, (String)"blob");
        Ensure.fileExists((File)sourceFile, (String)"sourceFile");
        blobClient.uploadFromFile(sourceFile.getPath());
    }

    void uploadStreamToBlob(InputStream inputStream, String blobName, BlobContainerClient container, boolean shouldCompress) throws IOException, URISyntaxException, BlobStorageException {
        log.debug("uploadStreamToBlob: blobName: {}, storageUri: {}", (Object)blobName, (Object)container);
        Ensure.argIsNotNull((Object)inputStream, (String)"inputStream");
        Ensure.stringIsNotBlank((String)blobName, (String)"blobName");
        Ensure.argIsNotNull((Object)container, (String)"container");
        BlobClient blobClient = container.getBlobClient(blobName);
        if (shouldCompress) {
            this.compressAndUploadStream(inputStream, blobClient);
        } else {
            this.uploadStream(inputStream, blobClient);
        }
    }

    void uploadStream(InputStream inputStream, BlobClient blob) throws IOException, BlobStorageException {
        Ensure.argIsNotNull((Object)inputStream, (String)"inputStream");
        Ensure.argIsNotNull((Object)blob, (String)"blob");
        BlobOutputStream blobOutputStream = blob.getBlockBlobClient().getBlobOutputStream(true);
        this.copyStream(inputStream, (OutputStream)blobOutputStream, 16384);
        blobOutputStream.close();
    }

    void compressAndUploadStream(InputStream inputStream, BlobClient blob) throws IOException, BlobStorageException {
        Ensure.argIsNotNull((Object)inputStream, (String)"inputStream");
        Ensure.argIsNotNull((Object)blob, (String)"blob");
        try (GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)blob.getBlockBlobClient().getBlobOutputStream(true));){
            this.copyStream(inputStream, gzout, 16384);
        }
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, length);
        }
    }
}

