/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.resources;

import com.azure.core.http.HttpClient;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueClientBuilder;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.ingest.resources.ResourceWithSas;
import java.net.URISyntaxException;
import reactor.util.annotation.Nullable;

public class QueueWithSas
implements ResourceWithSas<QueueClient> {
    private final String sas;
    private final QueueClient queue;

    public QueueWithSas(String url, HttpClient httpClient, @Nullable RequestRetryOptions retryOptions) throws URISyntaxException {
        String[] parts = UriUtils.getSasAndEndpointFromResourceURL((String)url);
        this.sas = '?' + parts[1];
        this.queue = new QueueClientBuilder().endpoint(parts[0]).sasToken(parts[1]).httpClient(httpClient).retryOptions(retryOptions).buildClient();
    }

    public String getSas() {
        return this.sas;
    }

    public QueueClient getQueue() {
        return this.queue;
    }

    public String getEndpoint() {
        return this.queue.getQueueUrl() + this.sas;
    }

    @Override
    public String getEndpointWithoutSas() {
        return this.queue.getQueueUrl();
    }

    @Override
    public String getAccountName() {
        return this.queue.getAccountName();
    }

    @Override
    public QueueClient getResource() {
        return this.queue;
    }
}

