/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class CorsRule
implements XmlSerializable<CorsRule> {
    private String allowedOrigins;
    private String allowedMethods;
    private String allowedHeaders;
    private String exposedHeaders;
    private int maxAgeInSeconds;

    public String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public CorsRule setAllowedOrigins(String allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public CorsRule setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public CorsRule setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public CorsRule setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public int getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public CorsRule setMaxAgeInSeconds(int maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "CorsRule" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("AllowedOrigins", this.allowedOrigins);
        xmlWriter.writeStringElement("AllowedMethods", this.allowedMethods);
        xmlWriter.writeStringElement("AllowedHeaders", this.allowedHeaders);
        xmlWriter.writeStringElement("ExposedHeaders", this.exposedHeaders);
        xmlWriter.writeIntElement("MaxAgeInSeconds", this.maxAgeInSeconds);
        return xmlWriter.writeEndElement();
    }

    public static CorsRule fromXml(XmlReader xmlReader) throws XMLStreamException {
        return CorsRule.fromXml(xmlReader, null);
    }

    public static CorsRule fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "CorsRule" : rootElementName;
        return (CorsRule)xmlReader.readObject(finalRootElementName, reader -> {
            CorsRule deserializedCorsRule = new CorsRule();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("AllowedOrigins".equals(elementName.getLocalPart())) {
                    deserializedCorsRule.allowedOrigins = reader.getStringElement();
                    continue;
                }
                if ("AllowedMethods".equals(elementName.getLocalPart())) {
                    deserializedCorsRule.allowedMethods = reader.getStringElement();
                    continue;
                }
                if ("AllowedHeaders".equals(elementName.getLocalPart())) {
                    deserializedCorsRule.allowedHeaders = reader.getStringElement();
                    continue;
                }
                if ("ExposedHeaders".equals(elementName.getLocalPart())) {
                    deserializedCorsRule.exposedHeaders = reader.getStringElement();
                    continue;
                }
                if ("MaxAgeInSeconds".equals(elementName.getLocalPart())) {
                    deserializedCorsRule.maxAgeInSeconds = reader.getIntElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedCorsRule;
        });
    }
}

