/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer;

import io.codearte.jfairy.producer.RandomGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BaseProducer {
    private final RandomGenerator random;

    @Inject
    public BaseProducer(RandomGenerator random) {
        this.random = random;
    }

    public boolean trueOrFalse() {
        return this.random.nextBoolean();
    }

    public <T> T randomElement(List<T> elements) {
        return elements.get(this.randomBetween(0, elements.size() - 1));
    }

    public <T> T randomElement(T ... elements) {
        return this.randomElement(Arrays.asList(elements));
    }

    public <T extends Enum<?>> T randomElement(Class<T> enumType) {
        return (T)((Enum[])enumType.getEnumConstants())[this.randomBetween(0, ((Enum[])enumType.getEnumConstants()).length - 1)];
    }

    public <T> List<T> randomElements(List<T> elements, int count) {
        if (elements.size() >= count) {
            return this.extractRandomList(elements, count);
        }
        ArrayList<T> randomElements = new ArrayList<T>();
        randomElements.addAll(this.extractRandomList(elements, count % elements.size()));
        do {
            randomElements.addAll(this.extractRandomList(elements, elements.size()));
        } while (randomElements.size() < count);
        return randomElements;
    }

    private <T> List<T> extractRandomList(List<T> elements, int count) {
        this.random.shuffle(elements);
        return elements.subList(0, count);
    }

    public <T> List<T> randomElements(int count, T ... elements) {
        return this.randomElements(Arrays.asList(elements), count);
    }

    public int randomBetween(int min, int max) {
        return this.random.nextInt(min, max);
    }

    public int randomInt(int max) {
        return this.randomBetween(0, max);
    }

    public char randomBetween(char min, char max) {
        return (char)this.randomBetween((int)min, (int)max);
    }

    public long randomBetween(long min, long max) {
        return this.random.nextDouble(min, max);
    }

    public double randomBetween(double min, double max) {
        return this.random.nextDouble(min, max);
    }

    public String letterify(String letterString) {
        return this.letterify(letterString, 'a', 'z');
    }

    public String letterify(String letterString, char from, char to) {
        return this.replaceSymbolWithCharsFromTo(letterString, '?', from, to);
    }

    public String numerify(String numberString) {
        return this.numerify(numberString, 0, 9);
    }

    public String numerify(String numberString, int from, int to) {
        return this.replaceSymbolWithCharsFromTo(numberString, '#', Character.forDigit(from, 10), Character.forDigit(to, 10));
    }

    public String bothify(String string) {
        return this.letterify(this.numerify(string));
    }

    private String replaceSymbolWithCharsFromTo(String string, char symbol, char from, char to) {
        StringBuilder result = new StringBuilder();
        for (char aChar : string.toCharArray()) {
            if (aChar == symbol) {
                result.append(this.randomBetween(from, to));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }
}

