/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.EndPointFactory;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TranslatedAddressEndPoint;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndPointFactory
implements EndPointFactory {
    private static final Logger logger = LoggerFactory.getLogger(ControlConnection.class);
    private static final InetAddress BIND_ALL_ADDRESS;
    private volatile Cluster cluster;

    @Override
    public void init(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public EndPoint create(Row peersRow) {
        if (peersRow.getColumnDefinitions().contains("native_address")) {
            InetAddress nativeAddress = peersRow.getInet("native_address");
            int nativePort = peersRow.getInt("native_port");
            InetSocketAddress translateAddress = this.cluster.manager.translateAddress(new InetSocketAddress(nativeAddress, nativePort));
            return new TranslatedAddressEndPoint(translateAddress);
        }
        if (peersRow.getColumnDefinitions().contains("native_transport_address")) {
            InetAddress nativeAddress = peersRow.getInet("native_transport_address");
            int nativePort = peersRow.getInt("native_transport_port");
            if (this.cluster.getConfiguration().getProtocolOptions().getSSLOptions() != null && !peersRow.isNull("native_transport_port_ssl")) {
                nativePort = peersRow.getInt("native_transport_port_ssl");
            }
            InetSocketAddress translateAddress = this.cluster.manager.translateAddress(new InetSocketAddress(nativeAddress, nativePort));
            return new TranslatedAddressEndPoint(translateAddress);
        }
        InetAddress broadcastAddress = peersRow.getInet("peer");
        InetAddress rpcAddress = peersRow.getInet("rpc_address");
        if (broadcastAddress == null || rpcAddress == null) {
            return null;
        }
        if (rpcAddress.equals(BIND_ALL_ADDRESS)) {
            logger.warn("Found host with 0.0.0.0 as rpc_address, using broadcast_address ({}) to contact it instead. If this is incorrect you should avoid the use of 0.0.0.0 server side.", (Object)broadcastAddress);
            rpcAddress = broadcastAddress;
        }
        InetSocketAddress translateAddress = this.cluster.manager.translateAddress(rpcAddress);
        return new TranslatedAddressEndPoint(translateAddress);
    }

    static {
        try {
            BIND_ALL_ADDRESS = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

