/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;

public class AdapterRequestCache {
    private final HashMap<Integer, AmazonWebServiceRequest> cacheMap = new HashMap();
    private final Deque<Integer> evictQueue = new LinkedList<Integer>();
    private final int capacity;

    public AdapterRequestCache(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be a positive number");
        }
        this.capacity = capacity;
    }

    public synchronized void addEntry(AmazonWebServiceRequest request, AmazonWebServiceRequest requestAdapter) {
        if (null == request || null == requestAdapter) {
            throw new IllegalArgumentException("Request and adapter request must not be null");
        }
        if (this.evictQueue.size() == this.capacity) {
            Integer evicted = this.evictQueue.removeLast();
            this.cacheMap.remove(evicted);
        }
        this.evictQueue.addFirst(System.identityHashCode(request));
        this.cacheMap.put(System.identityHashCode(request), requestAdapter);
    }

    public synchronized AmazonWebServiceRequest getEntry(AmazonWebServiceRequest request) {
        if (null == request) {
            throw new IllegalArgumentException("Request must not be null");
        }
        return this.cacheMap.get(System.identityHashCode(request));
    }
}

