/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.model;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.model.ExpiredIteratorException;
import com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TrimmedDataAccessException;
import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.exceptions.UnableToReadMoreRecordsException;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonServiceExceptionTransformer {
    private static final String TRIMMED_DATA_KCL_RETRY_MESSAGE = "Attempted to get a shard iterator for a trimmed shard. Data has been lost";
    public static final String DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE = "ThrottlingException";
    public static final String EMPTY_STRING = "";
    public static final String KINESIS_INTERNAL_ERROR_MESSAGE = "InternalFailure";
    public static final String KINESIS_VALIDATION_ERROR_MESSAGE = "ValidationError";
    private static final Log LOG = LogFactory.getLog(AmazonServiceExceptionTransformer.class);

    private static AmazonServiceException applyFields(AmazonServiceException original, AmazonServiceException transformed) {
        if (transformed == null) {
            LOG.error((Object)"Could not transform a DynamoDB AmazonServiceException to a compatible Kinesis exception", (Throwable)original);
            return original;
        }
        if (original.getErrorCode() != null) {
            transformed.setErrorCode(original.getErrorCode());
        }
        transformed.setErrorType(original.getErrorType());
        if (original.getRequestId() != null) {
            transformed.setRequestId(original.getRequestId());
        }
        if (original.getServiceName() != null) {
            transformed.setServiceName(original.getServiceName());
        }
        transformed.setStatusCode(original.getStatusCode());
        LOG.error((Object)String.format("DynamoDB Streams exception: %s tranformed to Kinesis %s", ((Object)((Object)original)).getClass(), ((Object)((Object)transformed)).getClass()), (Throwable)original);
        return transformed;
    }

    private static String buildErrorMessage(AmazonServiceException ase) {
        if (ase.getErrorMessage() == null) {
            return EMPTY_STRING;
        }
        return ase.getErrorMessage();
    }

    public static AmazonServiceException transformDynamoDBStreamsToKinesisDescribeStream(AmazonServiceException ase) {
        if (ase == null) {
            return ase;
        }
        Object transformed = ase instanceof InternalServerErrorException ? new AmazonServiceException(AmazonServiceExceptionTransformer.buildErrorMessage(ase), (Exception)((Object)ase)) : (ase instanceof ResourceNotFoundException ? new com.amazonaws.services.kinesis.model.ResourceNotFoundException(AmazonServiceExceptionTransformer.buildErrorMessage(ase)) : (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.getErrorCode()) ? new com.amazonaws.services.kinesis.model.LimitExceededException(AmazonServiceExceptionTransformer.buildErrorMessage(ase)) : null));
        return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)((Object)transformed));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AmazonServiceException transformDynamoDBStreamsToKinesisGetRecords(AmazonServiceException ase, AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior skipRecordsBehavior) {
        void var2_9;
        if (ase == null) {
            return ase;
        }
        if (ase instanceof ExpiredIteratorException) {
            com.amazonaws.services.kinesis.model.ExpiredIteratorException expiredIteratorException = new com.amazonaws.services.kinesis.model.ExpiredIteratorException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
        } else if (ase instanceof InternalServerErrorException) {
            AmazonServiceException amazonServiceException = new AmazonServiceException(AmazonServiceExceptionTransformer.buildErrorMessage(ase), (Exception)((Object)ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
        } else if (ase instanceof LimitExceededException) {
            ProvisionedThroughputExceededException provisionedThroughputExceededException = new ProvisionedThroughputExceededException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
        } else if (ase instanceof ResourceNotFoundException) {
            com.amazonaws.services.kinesis.model.ResourceNotFoundException resourceNotFoundException = new com.amazonaws.services.kinesis.model.ResourceNotFoundException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
        } else if (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.getErrorCode())) {
            ProvisionedThroughputExceededException provisionedThroughputExceededException = new ProvisionedThroughputExceededException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
        } else {
            if (!(ase instanceof TrimmedDataAccessException)) return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
            if (skipRecordsBehavior != AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) throw new UnableToReadMoreRecordsException("Attempted to access trimmed data. Data has been lost", ase);
            com.amazonaws.services.kinesis.model.ExpiredIteratorException expiredIteratorException = new com.amazonaws.services.kinesis.model.ExpiredIteratorException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
        }
        return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)var2_9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AmazonServiceException transformDynamoDBStreamsToKinesisGetShardIterator(AmazonServiceException ase, AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior skipRecordsBehavior) {
        AmazonServiceException transformed;
        if (ase == null) {
            return ase;
        }
        if (ase instanceof InternalServerErrorException) {
            transformed = new AmazonServiceException(AmazonServiceExceptionTransformer.buildErrorMessage(ase), (Exception)((Object)ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, transformed);
        } else if (ase instanceof ResourceNotFoundException) {
            if (skipRecordsBehavior != AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) throw new UnableToReadMoreRecordsException(TRIMMED_DATA_KCL_RETRY_MESSAGE, ase);
            transformed = new com.amazonaws.services.kinesis.model.ResourceNotFoundException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, transformed);
        } else if (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.getErrorCode())) {
            transformed = new ProvisionedThroughputExceededException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, transformed);
        } else if (ase instanceof TrimmedDataAccessException) {
            if (skipRecordsBehavior != AmazonDynamoDBStreamsAdapterClient.SkipRecordsBehavior.SKIP_RECORDS_TO_TRIM_HORIZON) throw new UnableToReadMoreRecordsException(TRIMMED_DATA_KCL_RETRY_MESSAGE, ase);
            transformed = new com.amazonaws.services.kinesis.model.ResourceNotFoundException(AmazonServiceExceptionTransformer.buildErrorMessage(ase));
            return AmazonServiceExceptionTransformer.applyFields(ase, transformed);
        } else {
            transformed = null;
        }
        return AmazonServiceExceptionTransformer.applyFields(ase, transformed);
    }

    public static AmazonServiceException transformDynamoDBStreamsToKinesisListStreams(AmazonServiceException ase) {
        if (ase == null) {
            return ase;
        }
        Throwable transformed = ase instanceof InternalServerErrorException ? new AmazonServiceException(AmazonServiceExceptionTransformer.buildErrorMessage(ase), (Exception)((Object)ase)) : (ase instanceof ResourceNotFoundException ? new AmazonServiceException(AmazonServiceExceptionTransformer.buildErrorMessage(ase), (Exception)((Object)ase)) : (DYNAMODB_STREAMS_THROTTLING_EXCEPTION_ERROR_CODE.equals(ase.getErrorCode()) ? new com.amazonaws.services.kinesis.model.LimitExceededException(AmazonServiceExceptionTransformer.buildErrorMessage(ase)) : null));
        return AmazonServiceExceptionTransformer.applyFields(ase, (AmazonServiceException)transformed);
    }
}

