/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.Publisher;
import com.sproutsocial.nsq.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Batcher {
    private final Publisher publisher;
    private final String topic;
    private final int maxSize;
    private final int maxDelayMillis;
    private final ScheduledExecutorService executor;
    private int size;
    private List<byte[]> batch = new ArrayList<byte[]>();
    private long sendTime;
    private static final Logger logger = LoggerFactory.getLogger(Batcher.class);

    public Batcher(Publisher publisher, String topic, int maxSizeBytes, int maxDelayMillis) {
        this.publisher = publisher;
        this.topic = topic;
        this.maxSize = maxSizeBytes;
        this.maxDelayMillis = maxDelayMillis;
        this.executor = publisher.getBatchExecutor();
        Util.checkNotNull(publisher);
        Util.checkNotNull(topic);
        Util.checkArgument(maxDelayMillis > 5);
        Util.checkArgument(maxDelayMillis <= 60000);
        Util.checkArgument(this.maxSize > 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(byte[] msg) {
        boolean sendNow = false;
        Batcher batcher = this;
        synchronized (batcher) {
            this.batch.add(msg);
            this.size += msg.length;
            if (this.batch.size() == 1) {
                this.sendTime = Util.clock() + (long)this.maxDelayMillis;
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Batcher.this.sendDelayedBatch();
                    }
                }, (long)this.maxDelayMillis, TimeUnit.MILLISECONDS);
            } else if (this.size >= this.maxSize) {
                sendNow = true;
            }
        }
        if (sendNow) {
            this.sendBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDelayedBatch() {
        try {
            boolean sendNow = false;
            Batcher batcher = this;
            synchronized (batcher) {
                if (!this.batch.isEmpty()) {
                    long delay = this.sendTime - Util.clock();
                    if (delay < 50L) {
                        sendNow = true;
                    } else {
                        this.executor.schedule(new Runnable(){

                            @Override
                            public void run() {
                                Batcher.this.sendDelayedBatch();
                            }
                        }, delay, TimeUnit.MILLISECONDS);
                    }
                }
            }
            if (sendNow) {
                this.sendBatch();
            }
        }
        catch (Throwable t) {
            logger.error("delayed batch error. messages possibly lost", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBatch() {
        List<byte[]> toSend = null;
        Batcher batcher = this;
        synchronized (batcher) {
            if (!this.batch.isEmpty()) {
                toSend = this.batch;
                int capacity = Math.min(this.maxSize, (int)((double)toSend.size() * 1.2));
                capacity = Math.max(10, capacity);
                this.batch = new ArrayList<byte[]>(capacity);
                this.size = 0;
            }
        }
        if (toSend != null) {
            this.publisher.publish(this.topic, toSend);
        }
    }
}

