/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sproutsocial.nsq.Publisher;
import com.sproutsocial.nsq.SubConnection;
import com.sproutsocial.nsq.Subscriber;
import com.sproutsocial.nsq.Util;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Client {
    private final Set<Publisher> publishers = new CopyOnWriteArraySet<Publisher>();
    private final Set<Subscriber> subscribers = new CopyOnWriteArraySet<Subscriber>();
    private final Set<SubConnection> subConnections = new CopyOnWriteArraySet<SubConnection>();
    private final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final Object subConMonitor = new Object();
    private final ScheduledExecutorService schedExecutor = Executors.newScheduledThreadPool(2, Util.threadFactory("nsq-sched"));
    private ExecutorService handlerExecutor;
    private SSLSocketFactory sslSocketFactory;
    private byte[] authSecret;
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private static final Client defaultClient = new Client();

    public static Client getDefaultClient() {
        return defaultClient;
    }

    public synchronized boolean stop() {
        return this.stop(2000);
    }

    public synchronized boolean stop(int waitMillis) {
        Util.checkArgument(waitMillis > 0);
        logger.info("stopping nsq client");
        boolean isClean = true;
        long start = Util.clock();
        isClean &= this.stopSubscribers(waitMillis);
        if (this.handlerExecutor != null && !this.handlerExecutor.isTerminated()) {
            int timeout = Math.max((int)((long)waitMillis - (Util.clock() - start)), 100);
            isClean &= Util.shutdownAndAwaitTermination(this.handlerExecutor, timeout, TimeUnit.MILLISECONDS);
        }
        for (Publisher publisher : this.publishers) {
            publisher.stop();
        }
        int timeout = Math.max((int)((long)waitMillis - (Util.clock() - start)), 100);
        logger.debug("handlerExecutor.isTerminated:{} schedExecutor.isTerminated:{} isClean:{}", new Object[]{this.handlerExecutor != null ? Boolean.valueOf(this.handlerExecutor.isTerminated()) : "null", this.schedExecutor.isTerminated(), isClean &= Util.shutdownAndAwaitTermination(this.schedExecutor, timeout, TimeUnit.MILLISECONDS)});
        logger.info("nsq client stopped");
        return isClean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stopSubscribers(int waitMillis) {
        Util.checkArgument(waitMillis > 0);
        for (Subscriber subscriber : this.subscribers) {
            subscriber.stop();
        }
        Object object = this.subConMonitor;
        synchronized (object) {
            if (!this.subConnections.isEmpty()) {
                logger.info("waiting for subscribers to finish in-flight messages");
                try {
                    this.subConMonitor.wait(waitMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        boolean isClean = this.subConnections.isEmpty();
        for (SubConnection subCon : this.subConnections) {
            subCon.close();
        }
        return isClean;
    }

    public synchronized void setExecutor(ExecutorService exec) {
        Util.checkNotNull(exec);
        Util.checkState(this.handlerExecutor == null, "executor can only be set once, must be set before subscribing");
        this.handlerExecutor = exec;
    }

    public synchronized ExecutorService getExecutor() {
        if (this.handlerExecutor == null) {
            this.handlerExecutor = Executors.newFixedThreadPool(6, Util.threadFactory("nsq-sub"));
        }
        return this.handlerExecutor;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public synchronized byte[] getAuthSecret() {
        return this.authSecret;
    }

    public synchronized void setAuthSecret(byte[] authSecret) {
        this.authSecret = authSecret;
    }

    public synchronized void setAuthSecret(String authSecret) {
        this.authSecret = authSecret.getBytes();
    }

    void addPublisher(Publisher publisher) {
        this.publishers.add(publisher);
    }

    void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    void addSubConnection(SubConnection subCon) {
        this.subConnections.add(subCon);
    }

    ScheduledExecutorService getSchedExecutor() {
        return this.schedExecutor;
    }

    ScheduledFuture scheduleAtFixedRate(final Runnable runnable, int initialDelay, int period, boolean jitter) {
        if (jitter) {
            initialDelay = (int)((double)initialDelay * 0.1 + Math.random() * (double)initialDelay * 0.9);
        }
        return this.schedExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    logger.error("task error", t);
                }
            }
        }, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    void schedule(final Runnable runnable, int delay) {
        this.schedExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    logger.error("task error", t);
                }
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(SubConnection closedCon) {
        Object object = this.subConMonitor;
        synchronized (object) {
            this.subConnections.remove(closedCon);
            if (this.subConnections.isEmpty()) {
                this.subConMonitor.notifyAll();
            }
        }
    }

    Gson getGson() {
        return this.gson;
    }

    synchronized boolean isLonePublisher(Publisher publisher) {
        return this.subscribers.isEmpty() && this.publishers.size() == 1 && this.publishers.iterator().next() == publisher;
    }
}

