/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.zookeeper.running;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.utils.BooleanMutex;
import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.common.zookeeper.ZookeeperPathUtils;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningData;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ServerRunningMonitor
extends AbstractCanalLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(ServerRunningMonitor.class);
    private ZkClientx zkClient;
    private String destination;
    private IZkDataListener dataListener;
    private BooleanMutex mutex = new BooleanMutex(false);
    private volatile boolean release = false;
    private ServerRunningData serverData;
    private volatile ServerRunningData activeData;
    private ScheduledExecutorService delayExector = Executors.newScheduledThreadPool(1);
    private int delayTime = 5;
    private ServerRunningListener listener;

    public ServerRunningMonitor(ServerRunningData serverData) {
        this();
        this.serverData = serverData;
    }

    public ServerRunningMonitor() {
        this.dataListener = new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) throws Exception {
                MDC.put((String)"destination", (String)ServerRunningMonitor.this.destination);
                ServerRunningData runningData = JsonUtils.unmarshalFromByte((byte[])data, ServerRunningData.class);
                if (!ServerRunningMonitor.this.isMine(runningData.getAddress())) {
                    ServerRunningMonitor.this.mutex.set(false);
                }
                if (!runningData.isActive() && ServerRunningMonitor.this.isMine(runningData.getAddress())) {
                    ServerRunningMonitor.this.releaseRunning();
                }
                ServerRunningMonitor.this.activeData = runningData;
            }

            public void handleDataDeleted(String dataPath) throws Exception {
                MDC.put((String)"destination", (String)ServerRunningMonitor.this.destination);
                ServerRunningMonitor.this.mutex.set(false);
                if (!ServerRunningMonitor.this.release && ServerRunningMonitor.this.activeData != null && ServerRunningMonitor.this.isMine(ServerRunningMonitor.this.activeData.getAddress())) {
                    ServerRunningMonitor.this.initRunning();
                } else {
                    ServerRunningMonitor.this.delayExector.schedule(() -> ServerRunningMonitor.this.initRunning(), (long)ServerRunningMonitor.this.delayTime, TimeUnit.SECONDS);
                }
            }
        };
    }

    public void init() {
        this.processStart();
    }

    @Override
    public synchronized void start() {
        super.start();
        try {
            this.processStart();
            if (this.zkClient != null) {
                String path = ZookeeperPathUtils.getDestinationServerRunning(this.destination);
                this.zkClient.subscribeDataChanges(path, this.dataListener);
                this.initRunning();
            } else {
                this.processActiveEnter();
            }
        }
        catch (Exception e) {
            logger.error("start failed", (Throwable)e);
            this.stop();
        }
    }

    public boolean release() {
        if (this.zkClient != null) {
            this.releaseRunning();
            return true;
        }
        this.processActiveExit();
        return false;
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.zkClient != null) {
            String path = ZookeeperPathUtils.getDestinationServerRunning(this.destination);
            this.zkClient.unsubscribeDataChanges(path, this.dataListener);
            this.releaseRunning();
        } else {
            this.processActiveExit();
        }
        this.processStop();
    }

    private void initRunning() {
        if (!this.isStart()) {
            return;
        }
        String path = ZookeeperPathUtils.getDestinationServerRunning(this.destination);
        byte[] bytes = JsonUtils.marshalToByte(this.serverData);
        try {
            this.mutex.set(false);
            this.zkClient.create(path, bytes, CreateMode.EPHEMERAL);
            this.activeData = this.serverData;
            this.processActiveEnter();
            this.mutex.set(true);
            this.release = false;
        }
        catch (ZkNodeExistsException e) {
            bytes = (byte[])this.zkClient.readData(path, true);
            if (bytes == null) {
                this.initRunning();
            } else {
                this.activeData = JsonUtils.unmarshalFromByte(bytes, ServerRunningData.class);
            }
        }
        catch (ZkNoNodeException e) {
            this.zkClient.createPersistent(ZookeeperPathUtils.getDestinationPath(this.destination), true);
            this.initRunning();
        }
    }

    public void waitForActive() throws InterruptedException {
        this.initRunning();
        this.mutex.get();
    }

    public boolean check() {
        String path = ZookeeperPathUtils.getDestinationServerRunning(this.destination);
        try {
            ServerRunningData eventData;
            byte[] bytes = (byte[])this.zkClient.readData(path);
            this.activeData = eventData = JsonUtils.unmarshalFromByte(bytes, ServerRunningData.class);
            boolean result = this.isMine(this.activeData.getAddress());
            if (!result) {
                logger.warn("canal is running in node[{}] , but not in node[{}]", (Object)this.activeData.getAddress(), (Object)this.serverData.getAddress());
            }
            return result;
        }
        catch (ZkNoNodeException e) {
            logger.warn("canal is not run any in node");
            return false;
        }
        catch (ZkInterruptedException e) {
            logger.warn("canal check is interrupt");
            Thread.interrupted();
            return this.check();
        }
        catch (ZkException e) {
            logger.warn("canal check is failed");
            return false;
        }
    }

    private boolean releaseRunning() {
        if (this.check()) {
            this.release = true;
            String path = ZookeeperPathUtils.getDestinationServerRunning(this.destination);
            this.zkClient.delete(path);
            this.mutex.set(false);
            this.processActiveExit();
            return true;
        }
        return false;
    }

    private boolean isMine(String address) {
        return address.equals(this.serverData.getAddress());
    }

    private void processStart() {
        if (this.listener != null) {
            try {
                this.listener.processStart();
            }
            catch (Exception e) {
                logger.error("processStart failed", (Throwable)e);
            }
        }
    }

    private void processStop() {
        if (this.listener != null) {
            try {
                this.listener.processStop();
            }
            catch (Exception e) {
                logger.error("processStop failed", (Throwable)e);
            }
        }
    }

    private void processActiveEnter() {
        if (this.listener != null) {
            this.listener.processActiveEnter();
        }
    }

    private void processActiveExit() {
        if (this.listener != null) {
            try {
                this.listener.processActiveExit();
            }
            catch (Exception e) {
                logger.error("processActiveExit failed", (Throwable)e);
            }
        }
    }

    public void setListener(ServerRunningListener listener) {
        this.listener = listener;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public void setServerData(ServerRunningData serverData) {
        this.serverData = serverData;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setZkClient(ZkClientx zkClient) {
        this.zkClient = zkClient;
    }
}

