/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy;

import com.google.inject.AbstractModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import io.codearte.jfairy.FairyFactory;
import io.codearte.jfairy.data.DataMaster;
import io.codearte.jfairy.producer.RandomGenerator;
import io.codearte.jfairy.producer.company.CompanyFactory;
import io.codearte.jfairy.producer.company.CompanyProvider;
import io.codearte.jfairy.producer.company.DefaultCompanyProvider;
import io.codearte.jfairy.producer.payment.DefaultIBANProvider;
import io.codearte.jfairy.producer.payment.IBANFactory;
import io.codearte.jfairy.producer.payment.IBANProvider;
import io.codearte.jfairy.producer.person.DefaultPersonProvider;
import io.codearte.jfairy.producer.person.PersonFactory;
import io.codearte.jfairy.producer.person.PersonProvider;

public abstract class FairyModule
extends AbstractModule {
    private final RandomGenerator randomGenerator;
    private final DataMaster dataMaster;

    public FairyModule(DataMaster dataMaster, RandomGenerator randomGenerator) {
        this.dataMaster = dataMaster;
        this.randomGenerator = randomGenerator;
    }

    protected void configure() {
        this.bind(DataMaster.class).toInstance((Object)this.dataMaster);
        this.bind(RandomGenerator.class).toInstance((Object)this.randomGenerator);
        this.install(new FactoryModuleBuilder().build(FairyFactory.class));
        this.install(new FactoryModuleBuilder().implement(PersonProvider.class, DefaultPersonProvider.class).build(PersonFactory.class));
        this.install(new FactoryModuleBuilder().implement(CompanyProvider.class, DefaultCompanyProvider.class).build(CompanyFactory.class));
        this.install(new FactoryModuleBuilder().implement(IBANProvider.class, DefaultIBANProvider.class).build(IBANFactory.class));
    }
}

