/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.TimeProvider;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

@Singleton
public class DateProducer {
    @VisibleForTesting
    static final int SECONDS_BEFORE_TO_BE_IN_THE_PAST = 1;
    private final BaseProducer baseProducer;
    private final TimeProvider timeProvider;

    @Inject
    public DateProducer(BaseProducer baseProducer, TimeProvider timeProvider) {
        this.baseProducer = baseProducer;
        this.timeProvider = timeProvider;
    }

    public DateTime randomDateInThePast(int maxYearsEarlier) {
        Preconditions.checkArgument((maxYearsEarlier >= 0 ? 1 : 0) != 0, (String)"%s has to be >= 0", (int)maxYearsEarlier);
        DateTime currentDate = this.timeProvider.getCurrentDate();
        DateTime latestDateInThePast = currentDate.minusSeconds(1);
        DateTime maxYearsEarlierDate = currentDate.minusYears(maxYearsEarlier);
        return this.randomDateBetweenTwoDates(maxYearsEarlierDate, latestDateInThePast);
    }

    public DateTime randomDateBetweenYearAndNow(int fromYear) {
        int actualYear = this.timeProvider.getCurrentYear();
        return this.randomDateInThePast(actualYear - fromYear);
    }

    public DateTime randomDateBetweenTwoDates(DateTime from, DateTime to) {
        return new DateTime(this.baseProducer.randomBetween(from.getMillis(), to.getMillis()));
    }

    public DateTime randomDateBetweenYears(int fromYear, int toYear) {
        Preconditions.checkArgument((fromYear <= toYear ? 1 : 0) != 0, (String)"%s has to be <= %s", (int)fromYear, (int)toYear);
        DateTime fromDate = this.getDateForFirstDayForGivenYear(fromYear);
        DateTime toDate = this.getDateForLastDayForGivenYear(toYear);
        return this.randomDateBetweenTwoDates(fromDate, toDate);
    }

    private DateTime getDateForLastDayForGivenYear(int year) {
        return new DateTime(this.getDateForFirstDayForGivenYear(year + 1).getMillis() - 1L);
    }

    private DateTime getDateForFirstDayForGivenYear(int year) {
        return new DateTime(year, 1, 1, 0, 0);
    }

    public DateTime randomDateBetweenNowAndFuturePeriod(Period futurePeriod) {
        DateTime now = this.timeProvider.getCurrentDate();
        return new DateTime(this.baseProducer.randomBetween(now.getMillis(), now.plus((ReadablePeriod)futurePeriod).getMillis()));
    }

    public DateTime randomDateInTheFuture(int years) {
        return this.randomDateBetweenNowAndFuturePeriod(Period.years((int)years));
    }

    public DateTime randomDateInTheFuture() {
        return this.randomDateInTheFuture(100);
    }
}

