/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.text;

import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.text.TextProducerInternal;
import io.codearte.jfairy.producer.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class TextProducer {
    private static final int DEFAULT_WORD_COUNT = 3;
    private static final int DEFAULT_WORD_COUNT_IN_SENTENCE = 3;
    private static final int DEFAULT_SENTENCE_COUNT = 3;
    private static final int SENTENCE_COUNT_PRECISION_MIN = 1;
    private static final int SENTENCE_COUNT_PRECISION_MAX = 3;
    private final TextProducerInternal textProducerInternal;
    private final BaseProducer baseProducer;
    private int limit = 0;

    @Inject
    public TextProducer(TextProducerInternal textProducerInternal, BaseProducer baseProducer) {
        this.textProducerInternal = textProducerInternal;
        this.baseProducer = baseProducer;
    }

    public TextProducer limitedTo(int limit) {
        this.limit = limit;
        return this;
    }

    public String result(String result) {
        if (this.limit > 0) {
            return StringUtils.left((String)result, (int)this.limit);
        }
        return result;
    }

    public String loremIpsum() {
        return this.result(this.textProducerInternal.loremIpsum());
    }

    public String text() {
        return this.result(this.textProducerInternal.text());
    }

    public String word() {
        return this.result(this.word(3));
    }

    public String word(int count) {
        return this.result(this.textProducerInternal.cleanWords(count));
    }

    public String latinWord() {
        return this.result(this.latinWord(3));
    }

    public String latinWord(int count) {
        return this.result(this.textProducerInternal.cleanLatinWords(count));
    }

    public String latinSentence() {
        return this.result(this.latinSentence(3));
    }

    public String latinSentence(int wordCount) {
        return this.result(this.textProducerInternal.latinSentence(wordCount));
    }

    public String sentence() {
        return this.result(this.sentence(3));
    }

    public String sentence(int wordCount) {
        return this.result(this.textProducerInternal.sentence(wordCount));
    }

    private List<String> sentences(int sentenceCount) {
        ArrayList<String> sentences = new ArrayList<String>(sentenceCount);
        for (int i = 0; i < sentenceCount; ++i) {
            sentences.add(this.sentence());
        }
        return sentences;
    }

    public String paragraph() {
        return this.result(this.paragraph(3));
    }

    public String paragraph(int sentenceCount) {
        return this.result(TextUtils.joinWithSpace(this.sentences(sentenceCount + this.baseProducer.randomBetween(1, 3))));
    }

    public String randomString(int charsCount) {
        return this.textProducerInternal.randomString(charsCount);
    }
}

