/*
 * Decompiled with CFR 0.152.
 */
package org.iban4j;

import org.iban4j.BicFormatException;
import org.iban4j.BicUtil;
import org.iban4j.CountryCode;
import org.iban4j.UnsupportedCountryException;

public final class Bic {
    private final String value;

    private Bic(String value) {
        this.value = value;
    }

    public static Bic valueOf(String bic) throws BicFormatException, UnsupportedCountryException {
        BicUtil.validate(bic);
        return new Bic(bic);
    }

    public String getBankCode() {
        return BicUtil.getBankCode(this.value);
    }

    public CountryCode getCountryCode() {
        return CountryCode.getByCode(BicUtil.getCountryCode(this.value));
    }

    public String getLocationCode() {
        return BicUtil.getLocationCode(this.value);
    }

    public String getBranchCode() {
        if (BicUtil.hasBranchCode(this.value)) {
            return BicUtil.getBranchCode(this.value);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bic) {
            return this.value.equals(((Bic)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

