/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.Immutable;
import io.debezium.document.Array;
import io.debezium.document.BinaryValue;
import io.debezium.document.ComparableValue;
import io.debezium.document.Document;
import io.debezium.document.NullValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

@Immutable
public interface Value
extends Comparable<Value> {
    public static boolean isNull(Value value) {
        return value == null || value.isNull();
    }

    public static boolean notNull(Value value) {
        return value != null && !value.isNull();
    }

    public static boolean isValid(Object value) {
        return value == null || value instanceof Value || value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Document || value instanceof Array || value instanceof BigInteger || value instanceof BigDecimal;
    }

    public static int compareTo(Value value1, Value value2) {
        if (value1 == null) {
            return Value.isNull(value2) ? 0 : -1;
        }
        return value1.compareTo(value2);
    }

    public static Value create(Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        if (!Value.isValid(value)) {
            if (!1.$assertionsDisabled && value == null) {
                throw new AssertionError();
            }
            throw new IllegalArgumentException("Unexpected value " + String.valueOf(value) + "' of type " + String.valueOf(value.getClass()));
        }
        return value == null ? NullValue.INSTANCE : new ComparableValue((Comparable)value);
    }

    public static Value create(boolean value) {
        return new ComparableValue(Boolean.valueOf(value));
    }

    public static Value create(int value) {
        return new ComparableValue(Integer.valueOf(value));
    }

    public static Value create(long value) {
        return new ComparableValue(Long.valueOf(value));
    }

    public static Value create(float value) {
        return new ComparableValue(Float.valueOf(value));
    }

    public static Value create(double value) {
        return new ComparableValue(Double.valueOf(value));
    }

    public static Value create(BigInteger value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(BigDecimal value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(Integer value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(Long value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(Float value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(Double value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(String value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue((Comparable<?>)((Object)value));
    }

    public static Value create(byte[] value) {
        return value == null ? NullValue.INSTANCE : new BinaryValue(value);
    }

    public static Value create(Document value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value create(Array value) {
        return value == null ? NullValue.INSTANCE : new ComparableValue(value);
    }

    public static Value nullValue() {
        return NullValue.INSTANCE;
    }

    default public Type getType() {
        return ComparableValue.typeForValue(this);
    }

    public Object asObject();

    public String asString();

    public Integer asInteger();

    public Long asLong();

    public Boolean asBoolean();

    public Number asNumber();

    public BigInteger asBigInteger();

    public BigDecimal asBigDecimal();

    public Float asFloat();

    public Double asDouble();

    public Document asDocument();

    public Array asArray();

    public byte[] asBytes();

    public boolean isNull();

    default public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean isString();

    public boolean isInteger();

    public boolean isLong();

    public boolean isBoolean();

    public boolean isNumber();

    public boolean isBigInteger();

    public boolean isBigDecimal();

    public boolean isFloat();

    public boolean isDouble();

    public boolean isDocument();

    public boolean isArray();

    public boolean isBinary();

    public Value convert();

    default public Value comparable() {
        if (this instanceof ComparableValue) {
            return this;
        }
        return new ComparableValue(this);
    }

    public Value clone();

    default public boolean ifDocument(Consumer<Document> consumer) {
        if (this.isDocument()) {
            consumer.accept(this.asDocument());
            return true;
        }
        return false;
    }

    default public boolean ifArray(Consumer<Array> consumer) {
        if (this.isArray()) {
            consumer.accept(this.asArray());
            return true;
        }
        return false;
    }

    default public boolean ifString(Consumer<String> consumer) {
        if (this.isString()) {
            consumer.accept(this.asString());
            return true;
        }
        return false;
    }

    default public boolean ifBoolean(Consumer<Boolean> consumer) {
        if (this.isBoolean()) {
            consumer.accept(this.asBoolean());
            return true;
        }
        return false;
    }

    default public boolean ifBinary(Consumer<byte[]> consumer) {
        if (this.isBinary()) {
            consumer.accept(this.asBytes());
            return true;
        }
        return false;
    }

    default public boolean ifInteger(IntConsumer consumer) {
        if (this.isInteger()) {
            consumer.accept(this.asInteger());
            return true;
        }
        return false;
    }

    default public boolean ifLong(LongConsumer consumer) {
        if (this.isLong()) {
            consumer.accept(this.asLong());
            return true;
        }
        return false;
    }

    default public boolean ifFloat(DoubleConsumer consumer) {
        if (this.isFloat()) {
            consumer.accept(this.asFloat().doubleValue());
            return true;
        }
        return false;
    }

    default public boolean ifDouble(DoubleConsumer consumer) {
        if (this.isDouble()) {
            consumer.accept(this.asDouble().intValue());
            return true;
        }
        return false;
    }

    default public boolean ifBigInteger(Consumer<BigInteger> consumer) {
        if (this.isBigInteger()) {
            consumer.accept(this.asBigInteger());
            return true;
        }
        return false;
    }

    default public boolean ifBigDecimal(Consumer<BigDecimal> consumer) {
        if (this.isBigDecimal()) {
            consumer.accept(this.asBigDecimal());
            return true;
        }
        return false;
    }

    default public boolean ifNull(NullHandler consumer) {
        if (this.isNull()) {
            consumer.call();
            return true;
        }
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum Type {
        NULL,
        STRING,
        BOOLEAN,
        BINARY,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BIG_INTEGER,
        DECIMAL,
        DOCUMENT,
        ARRAY;

    }

    @FunctionalInterface
    public static interface NullHandler {
        public void call();
    }
}

