/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.text;

import io.debezium.annotation.Immutable;
import java.text.StringCharacterIterator;

@Immutable
public class XmlCharacters {
    private static final int NUMBER_OF_CHARACTERS = 65536;
    private static final char[] MASKS = new char[65536];
    private static final int VALID_CHARACTER = 1;
    private static final int CONTENT_CHARACTER = 2;
    private static final int SPACE_CHARACTER = 4;
    private static final int NAME_START_CHARACTER = 8;
    private static final int NAME_CHARACTER = 16;
    private static final int NCNAME_START_CHARACTER = 32;
    private static final int NCNAME_CHARACTER = 64;
    private static final int PUBID_CHARACTER = 128;

    private XmlCharacters() {
    }

    public static boolean isValidNameStart(int c) {
        return c < 65536 && (MASKS[c] & 8) != 0;
    }

    public static boolean isValidNcNameStart(int c) {
        return c < 65536 && (MASKS[c] & 0x20) != 0;
    }

    public static boolean isValidName(int c) {
        return c < 65536 && (MASKS[c] & 0x10) != 0;
    }

    public static boolean isValidNcName(int c) {
        return c < 65536 && (MASKS[c] & 0x40) != 0;
    }

    public static boolean isValidPubid(int c) {
        return c < 65536 && (MASKS[c] & 0x80) != 0;
    }

    public static boolean isValid(int c) {
        return c < 65536 && (MASKS[c] & '\u0001') != 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static boolean isValidContent(int c) {
        return c < 65536 && (MASKS[c] & 2) != 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static boolean isValidSpace(int c) {
        return c <= 32 && (MASKS[c] & 4) != 0;
    }

    public static boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(name);
        char c = iter.first();
        if (!XmlCharacters.isValidNameStart(c)) {
            return false;
        }
        while (c != '\uffff') {
            if (!XmlCharacters.isValidName(c)) {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    public static boolean isValidNcName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(name);
        char c = iter.first();
        if (!XmlCharacters.isValidNcNameStart(c)) {
            return false;
        }
        while (c != '\uffff') {
            if (!XmlCharacters.isValidNcName(c)) {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    static {
        MASKS[9] = (char)(MASKS[9] | 3);
        MASKS[10] = (char)(MASKS[10] | 3);
        MASKS[13] = (char)(MASKS[13] | 3);
        int i = 32;
        while (i <= 55295) {
            int n = i++;
            MASKS[n] = (char)(MASKS[n] | 3);
        }
        i = 57344;
        while (i <= 65533) {
            int n = i++;
            MASKS[n] = (char)(MASKS[n] | 3);
        }
        MASKS[60] = (char)(MASKS[60] & 0xFFFFFFFD);
        MASKS[38] = (char)(MASKS[38] & 0xFFFFFFFD);
        MASKS[10] = (char)(MASKS[10] & 0xFFFFFFFD);
        MASKS[13] = (char)(MASKS[13] & 0xFFFFFFFD);
        MASKS[93] = (char)(MASKS[93] & 0xFFFFFFFD);
        MASKS[32] = (char)(MASKS[32] | 4);
        MASKS[9] = (char)(MASKS[9] | 4);
        MASKS[10] = (char)(MASKS[10] | 4);
        MASKS[13] = (char)(MASKS[13] | 4);
        int nameStartMask = 120;
        MASKS[58] = (char)(MASKS[58] | nameStartMask);
        MASKS[95] = (char)(MASKS[95] | nameStartMask);
        int i2 = 65;
        while (i2 <= 90) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 97;
        while (i2 <= 122) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 192;
        while (i2 <= 214) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 216;
        while (i2 <= 246) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 248;
        while (i2 <= 767) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 880;
        while (i2 <= 893) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 895;
        while (i2 <= 8191) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 8204;
        while (i2 <= 8205) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 8304;
        while (i2 <= 8591) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 11264;
        while (i2 <= 12271) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 12289;
        while (i2 <= 55295) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 63744;
        while (i2 <= 64975) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i2 = 65008;
        while (i2 <= 65533) {
            int n = i2++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        int nameMask = 80;
        MASKS[45] = (char)(MASKS[45] | nameMask);
        MASKS[46] = (char)(MASKS[46] | nameMask);
        MASKS[183] = (char)(MASKS[183] | nameMask);
        int i3 = 48;
        while (i3 <= 57) {
            int n = i3++;
            MASKS[n] = (char)(MASKS[n] | nameMask);
        }
        i3 = 768;
        while (i3 <= 879) {
            int n = i3++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        i3 = 8255;
        while (i3 <= 8256) {
            int n = i3++;
            MASKS[n] = (char)(MASKS[n] | nameStartMask);
        }
        MASKS[58] = (char)(MASKS[58] & 0xFFFFFF9F);
        MASKS[32] = (char)(MASKS[32] | 0x80);
        MASKS[10] = (char)(MASKS[10] | 0x80);
        MASKS[13] = (char)(MASKS[13] | 0x80);
        i3 = 65;
        while (i3 <= 90) {
            int n = i3++;
            MASKS[n] = (char)(MASKS[n] | 0x80);
        }
        i3 = 97;
        while (i3 <= 122) {
            int n = i3++;
            MASKS[n] = (char)(MASKS[n] | 0x80);
        }
        i3 = 48;
        while (i3 <= 57) {
            int n = i3++;
            MASKS[n] = (char)(MASKS[n] | 0x80);
        }
        MASKS[45] = (char)(MASKS[45] | 0x80);
        MASKS[39] = (char)(MASKS[39] | 0x80);
        MASKS[40] = (char)(MASKS[40] | 0x80);
        MASKS[41] = (char)(MASKS[41] | 0x80);
        MASKS[43] = (char)(MASKS[43] | 0x80);
        MASKS[44] = (char)(MASKS[44] | 0x80);
        MASKS[46] = (char)(MASKS[46] | 0x80);
        MASKS[47] = (char)(MASKS[47] | 0x80);
        MASKS[58] = (char)(MASKS[58] | 0x80);
        MASKS[61] = (char)(MASKS[61] | 0x80);
        MASKS[63] = (char)(MASKS[63] | 0x80);
        MASKS[59] = (char)(MASKS[59] | 0x80);
        MASKS[33] = (char)(MASKS[33] | 0x80);
        MASKS[42] = (char)(MASKS[42] | 0x80);
        MASKS[35] = (char)(MASKS[35] | 0x80);
        MASKS[64] = (char)(MASKS[64] | 0x80);
        MASKS[36] = (char)(MASKS[36] | 0x80);
        MASKS[95] = (char)(MASKS[95] | 0x80);
        MASKS[37] = (char)(MASKS[37] | 0x80);
    }
}

