/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class IsoTimestamp {
    public static final String SCHEMA_NAME = "io.debezium.time.IsoTimestamp";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public static SchemaBuilder builder() {
        return SchemaBuilder.string().name(SCHEMA_NAME).version(Integer.valueOf(1));
    }

    public static Schema schema() {
        return IsoTimestamp.builder().build();
    }

    public static String toIsoString(Object value, TemporalAdjuster adjuster) {
        LocalDateTime dateTime = value instanceof Long ? Instant.ofEpochMilli((Long)value).atOffset(ZoneOffset.UTC).toLocalDateTime() : Conversions.toLocalDateTime(value);
        if (adjuster != null) {
            dateTime = dateTime.with(adjuster);
        }
        return dateTime.atOffset(ZoneOffset.UTC).format(FORMATTER);
    }

    private IsoTimestamp() {
    }
}

