/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.annotation.Immutable;
import io.debezium.data.Json;
import io.debezium.data.SchemaUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;

public class VectorToJsonConverter<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final String DOUBLE_VECTOR_NAME = "io.debezium.data.DoubleVector";
    private static final String FLOAT_VECTOR_NAME = "io.debezium.data.FloatVector";
    private static final String SPARSE_DOUBLE_VECTOR_NAME = "io.debezium.data.SparseDoubleVector";

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void configure(Map<String, ?> configs) {
    }

    public R apply(R record) {
        if (record.value() == null) {
            return record;
        }
        TransformationResult result = this.transformStruct(Requirements.requireStruct((Object)record.value(), (String)"Value should be a struct"), record.valueSchema());
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), result.transformedSchema, (Object)result.transformedStruct, record.timestamp(), (Iterable)record.headers());
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }

    private TransformationResult transformStruct(Struct originalStruct, Schema originalSchema) {
        Struct transformedStruct;
        SchemaBuilder builder = SchemaUtil.copySchemaBasics(originalSchema);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (Field field : originalSchema.fields()) {
            Struct fieldStruct;
            Object fieldValue;
            Schema fieldSchema = field.schema();
            Object object = fieldValue = originalStruct != null ? originalStruct.get(field) : null;
            if (DOUBLE_VECTOR_NAME.equals(fieldSchema.name()) || FLOAT_VECTOR_NAME.equals(fieldSchema.name())) {
                builder.field(field.name(), VectorToJsonConverter.getJsonSchema(fieldSchema));
                fieldValues.put(field.name(), VectorToJsonConverter.vectorToJson((Collection)fieldValue));
                continue;
            }
            if (SPARSE_DOUBLE_VECTOR_NAME.equals(fieldSchema.name())) {
                fieldStruct = Requirements.requireStructOrNull((Object)fieldValue, (String)"SparseDoubleVector should be a struct.");
                builder.field(field.name(), VectorToJsonConverter.getJsonSchema(fieldSchema));
                fieldValues.put(field.name(), VectorToJsonConverter.sparseVectorToJson(fieldStruct));
                continue;
            }
            if (Schema.Type.STRUCT.equals((Object)fieldSchema.type())) {
                fieldStruct = Requirements.requireStructOrNull((Object)fieldValue, (String)"Should be a struct.");
                TransformationResult result = this.transformStruct(fieldStruct, fieldSchema);
                builder.field(field.name(), result.transformedSchema);
                fieldValues.put(field.name(), result.transformedStruct);
                continue;
            }
            builder.field(field.name(), fieldSchema);
            fieldValues.put(field.name(), fieldValue);
        }
        Schema transformedSchema = builder.build();
        if (originalStruct != null) {
            transformedStruct = new Struct(transformedSchema);
            fieldValues.forEach((arg_0, arg_1) -> ((Struct)transformedStruct).put(arg_0, arg_1));
        } else {
            transformedStruct = null;
        }
        return new TransformationResult(transformedSchema, transformedStruct);
    }

    private static Schema getJsonSchema(Schema fieldSchema) {
        if (fieldSchema.isOptional()) {
            return Json.builder().optional().build();
        }
        return Json.schema();
    }

    private static String vectorToJson(Collection<?> values) {
        if (values == null) {
            return null;
        }
        return "{ \"values\": [" + values.stream().map(String::valueOf).collect(Collectors.joining(", ")) + "] }";
    }

    private static String sparseVectorToJson(Struct sparseVector) {
        if (sparseVector == null) {
            return null;
        }
        Short dimensions = sparseVector.getInt16("dimensions");
        TreeMap vectorMap = new TreeMap(sparseVector.getMap("vector"));
        String vector = vectorMap.entrySet().stream().map(e -> "\"" + String.valueOf(e.getKey()) + "\": " + String.valueOf(e.getValue())).collect(Collectors.joining(", "));
        return String.format("{ \"dimensions\": %d, \"vector\": { %s } }", dimensions, vector);
    }

    @Immutable
    private static class TransformationResult {
        final Schema transformedSchema;
        final Struct transformedStruct;

        TransformationResult(Schema transformedSchema, Struct transformedStruct) {
            this.transformedSchema = transformedSchema;
            this.transformedStruct = transformedStruct;
        }
    }
}

