/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoClientException;
import com.mongodb.internal.authentication.AzureCredentialHelper;
import com.mongodb.internal.authentication.CredentialInfo;
import com.mongodb.internal.authentication.HttpHelper;
import java.time.Duration;
import java.util.HashMap;
import org.bson.BsonDocument;

public final class GcpCredentialHelper {
    public static BsonDocument obtainFromEnvironment() {
        String endpoint = "http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Metadata-Flavor", "Google");
        String response = HttpHelper.getHttpContents("GET", endpoint, header);
        BsonDocument responseDocument = BsonDocument.parse((String)response);
        if (responseDocument.containsKey((Object)"access_token")) {
            return new BsonDocument("accessToken", responseDocument.get((Object)"access_token"));
        }
        throw new MongoClientException("access_token is missing from GCE metadata response.  Full response is ''" + response);
    }

    public static CredentialInfo fetchGcpCredentialInfo(String audience) {
        String endpoint = "http://metadata/computeMetadata/v1/instance/service-accounts/default/identity?audience=" + AzureCredentialHelper.getEncoded(audience);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Metadata-Flavor", "Google");
        String response = HttpHelper.getHttpContents("GET", endpoint, header);
        return new CredentialInfo(response, Duration.ZERO);
    }

    private GcpCredentialHelper() {
    }
}

