/*
 * Decompiled with CFR 0.152.
 */
package com.sproutsocial.nsq;

import com.sproutsocial.nsq.Client;
import com.sproutsocial.nsq.Connection;
import com.sproutsocial.nsq.HostAndPort;
import com.sproutsocial.nsq.Publisher;
import java.io.IOException;
import java.util.List;

class PubConnection
extends Connection {
    private final Publisher publisher;

    public PubConnection(Client client, HostAndPort host, Publisher publisher) {
        super(client, host);
        this.publisher = publisher;
    }

    public synchronized void publish(String topic, byte[] data) throws IOException {
        this.respQueue.clear();
        this.writeCommand("PUB", topic);
        this.write(data);
        this.flushAndReadOK();
    }

    public synchronized void publishDeferred(String topic, byte[] data, long delayMillis) throws IOException {
        this.respQueue.clear();
        this.writeCommand("DPUB", topic, Long.toString(delayMillis));
        this.write(data);
        this.flushAndReadOK();
    }

    public synchronized void publish(String topic, List<byte[]> dataList) throws IOException {
        this.respQueue.clear();
        this.writeCommand("MPUB", topic);
        int bodySize = 4;
        for (byte[] data : dataList) {
            bodySize += data.length + 4;
        }
        this.out.writeInt(bodySize);
        this.out.writeInt(dataList.size());
        for (byte[] data : dataList) {
            this.write(data);
        }
        this.flushAndReadOK();
    }

    @Override
    public void close() {
        super.close();
        if (!this.publisher.isStopping) {
            this.client.getSchedExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PubConnection.this.publisher.connectionClosed(PubConnection.this);
                }
            });
        }
    }

    public String toString() {
        return String.format("PubCon:%s", this.host.getHost());
    }
}

