/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.common.consumer.ReceiptHandle;

public class MessageReceiptHandle {
    private final String group;
    private final String topic;
    private final int queueId;
    private final String messageId;
    private final long queueOffset;
    private final String originalReceiptHandleStr;
    private final int reconsumeTimes;
    private final AtomicInteger renewRetryTimes = new AtomicInteger(0);
    private volatile long timestamp;
    private volatile long expectInvisibleTime;
    private volatile String receiptHandleStr;

    public MessageReceiptHandle(String group, String topic, int queueId, String receiptHandleStr, String messageId, long queueOffset, int reconsumeTimes) {
        ReceiptHandle receiptHandle = ReceiptHandle.decode((String)receiptHandleStr);
        this.group = group;
        this.topic = topic;
        this.queueId = queueId;
        this.receiptHandleStr = receiptHandleStr;
        this.originalReceiptHandleStr = receiptHandleStr;
        this.messageId = messageId;
        this.queueOffset = queueOffset;
        this.reconsumeTimes = reconsumeTimes;
        this.expectInvisibleTime = receiptHandle.getInvisibleTime();
        this.timestamp = receiptHandle.getRetrieveTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageReceiptHandle handle = (MessageReceiptHandle)o;
        return this.queueId == handle.queueId && this.queueOffset == handle.queueOffset && this.timestamp == handle.timestamp && this.reconsumeTimes == handle.reconsumeTimes && this.expectInvisibleTime == handle.expectInvisibleTime && Objects.equal((Object)this.group, (Object)handle.group) && Objects.equal((Object)this.topic, (Object)handle.topic) && Objects.equal((Object)this.messageId, (Object)handle.messageId) && Objects.equal((Object)this.originalReceiptHandleStr, (Object)handle.originalReceiptHandleStr) && Objects.equal((Object)this.receiptHandleStr, (Object)handle.receiptHandleStr);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.group, this.topic, this.queueId, this.messageId, this.queueOffset, this.originalReceiptHandleStr, this.timestamp, this.reconsumeTimes, this.expectInvisibleTime, this.receiptHandleStr});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group).add("topic", (Object)this.topic).add("queueId", this.queueId).add("messageId", (Object)this.messageId).add("queueOffset", this.queueOffset).add("originalReceiptHandleStr", (Object)this.originalReceiptHandleStr).add("reconsumeTimes", this.reconsumeTimes).add("renewRetryTimes", (Object)this.renewRetryTimes).add("timestamp", this.timestamp).add("expectInvisibleTime", this.expectInvisibleTime).add("receiptHandleStr", (Object)this.receiptHandleStr).toString();
    }

    public String getGroup() {
        return this.group;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public String getReceiptHandleStr() {
        return this.receiptHandleStr;
    }

    public String getOriginalReceiptHandleStr() {
        return this.originalReceiptHandleStr;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public long getQueueOffset() {
        return this.queueOffset;
    }

    public int getReconsumeTimes() {
        return this.reconsumeTimes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getExpectInvisibleTime() {
        return this.expectInvisibleTime;
    }

    public void updateReceiptHandle(String receiptHandleStr) {
        ReceiptHandle receiptHandle = ReceiptHandle.decode((String)receiptHandleStr);
        this.receiptHandleStr = receiptHandleStr;
        this.expectInvisibleTime = receiptHandle.getInvisibleTime();
        this.timestamp = receiptHandle.getRetrieveTime();
    }

    public int incrementAndGetRenewRetryTimes() {
        return this.renewRetryTimes.incrementAndGet();
    }

    public void resetRenewRetryTimes() {
        this.renewRetryTimes.set(0);
    }

    public int getRenewRetryTimes() {
        return this.renewRetryTimes.get();
    }
}

