/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.relay;

import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.proxy.service.relay.RelayData;
import org.apache.rocketmq.proxy.service.transaction.TransactionData;
import org.apache.rocketmq.proxy.service.transaction.TransactionService;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;

public abstract class AbstractProxyRelayService
implements ProxyRelayService {
    protected final TransactionService transactionService;

    public AbstractProxyRelayService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public RelayData<TransactionData, Void> processCheckTransactionState(ProxyContext context, RemotingCommand command, CheckTransactionStateRequestHeader header, MessageExt messageExt) {
        CompletableFuture future = new CompletableFuture();
        String group = messageExt.getProperty("PGROUP");
        TransactionData transactionData = this.transactionService.addTransactionDataByBrokerAddr((String)command.getExtFields().get("brokerAddr"), group, header.getTranStateTableOffset(), header.getCommitLogOffset(), header.getTransactionId(), (Message)messageExt);
        if (transactionData == null) {
            throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, String.format("add transaction data failed. request:%s, message:%s", command, messageExt));
        }
        future.exceptionally(throwable -> {
            this.transactionService.onSendCheckTransactionStateFailed(context, group, transactionData);
            return null;
        });
        return new RelayData<TransactionData, Void>(transactionData, future);
    }
}

