/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.body;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class BrokerReplicasInfo
extends RemotingSerializable {
    private Map<String, ReplicasInfo> replicasInfoTable = new HashMap<String, ReplicasInfo>();

    public void addReplicaInfo(String brokerName, ReplicasInfo replicasInfo) {
        this.replicasInfoTable.put(brokerName, replicasInfo);
    }

    public Map<String, ReplicasInfo> getReplicasInfoTable() {
        return this.replicasInfoTable;
    }

    public void setReplicasInfoTable(Map<String, ReplicasInfo> replicasInfoTable) {
        this.replicasInfoTable = replicasInfoTable;
    }

    public static class ReplicaIdentity
    extends RemotingSerializable {
        private String address;
        private Long brokerId;

        public ReplicaIdentity(String address, Long brokerId) {
            this.address = address;
            this.brokerId = brokerId;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Long getBrokerId() {
            return this.brokerId;
        }

        public void setBrokerId(Long brokerId) {
            this.brokerId = brokerId;
        }

        public String toString() {
            return "{address='" + this.address + '\'' + ", brokerId=" + this.brokerId + '}';
        }
    }

    public static class ReplicasInfo
    extends RemotingSerializable {
        private String masterAddress;
        private int masterEpoch;
        private int syncStateSetEpoch;
        private List<ReplicaIdentity> inSyncReplicas;
        private List<ReplicaIdentity> notInSyncReplicas;

        public ReplicasInfo(String masterAddress, int masterEpoch, int syncStateSetEpoch, List<ReplicaIdentity> inSyncReplicas, List<ReplicaIdentity> notInSyncReplicas) {
            this.masterAddress = masterAddress;
            this.masterEpoch = masterEpoch;
            this.syncStateSetEpoch = syncStateSetEpoch;
            this.inSyncReplicas = inSyncReplicas;
            this.notInSyncReplicas = notInSyncReplicas;
        }

        public String getMasterAddress() {
            return this.masterAddress;
        }

        public void setMasterAddress(String masterAddress) {
            this.masterAddress = masterAddress;
        }

        public int getMasterEpoch() {
            return this.masterEpoch;
        }

        public void setMasterEpoch(int masterEpoch) {
            this.masterEpoch = masterEpoch;
        }

        public int getSyncStateSetEpoch() {
            return this.syncStateSetEpoch;
        }

        public void setSyncStateSetEpoch(int syncStateSetEpoch) {
            this.syncStateSetEpoch = syncStateSetEpoch;
        }

        public List<ReplicaIdentity> getInSyncReplicas() {
            return this.inSyncReplicas;
        }

        public void setInSyncReplicas(List<ReplicaIdentity> inSyncReplicas) {
            this.inSyncReplicas = inSyncReplicas;
        }

        public List<ReplicaIdentity> getNotInSyncReplicas() {
            return this.notInSyncReplicas;
        }

        public void setNotInSyncReplicas(List<ReplicaIdentity> notInSyncReplicas) {
            this.notInSyncReplicas = notInSyncReplicas;
        }
    }
}

