/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.BrokerAddrInfo;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.BrokerLiveInfo;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;

public class DefaultBrokerHeartbeatManager
implements BrokerHeartbeatManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private static final long DEFAULT_BROKER_CHANNEL_EXPIRED_TIME = 10000L;
    private final ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("DefaultBrokerHeartbeatManager_scheduledService_"));
    private final ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)new ThreadFactoryImpl("DefaultBrokerHeartbeatManager_executorService_"));
    private final ControllerConfig controllerConfig;
    private final Map<BrokerAddrInfo, BrokerLiveInfo> brokerLiveTable;
    private final List<BrokerHeartbeatManager.BrokerLifecycleListener> brokerLifecycleListeners;

    public DefaultBrokerHeartbeatManager(ControllerConfig controllerConfig) {
        this.controllerConfig = controllerConfig;
        this.brokerLiveTable = new ConcurrentHashMap<BrokerAddrInfo, BrokerLiveInfo>(256);
        this.brokerLifecycleListeners = new ArrayList<BrokerHeartbeatManager.BrokerLifecycleListener>();
    }

    @Override
    public void start() {
        this.scheduledService.scheduleAtFixedRate(this::scanNotActiveBroker, 2000L, this.controllerConfig.getScanNotActiveBrokerInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.scheduledService.shutdown();
        this.executor.shutdown();
    }

    public void scanNotActiveBroker() {
        try {
            log.info("start scanNotActiveBroker");
            Iterator<Map.Entry<BrokerAddrInfo, BrokerLiveInfo>> iterator = this.brokerLiveTable.entrySet().iterator();
            while (iterator.hasNext()) {
                long timeoutMillis;
                Map.Entry<BrokerAddrInfo, BrokerLiveInfo> next = iterator.next();
                long last = next.getValue().getLastUpdateTimestamp();
                if (last + (timeoutMillis = next.getValue().getHeartbeatTimeoutMillis()) >= System.currentTimeMillis()) continue;
                Channel channel = next.getValue().getChannel();
                iterator.remove();
                if (channel != null) {
                    RemotingHelper.closeChannel((Channel)channel);
                }
                this.executor.submit(() -> this.notifyBrokerInActive(((BrokerAddrInfo)next.getKey()).getClusterName(), ((BrokerLiveInfo)next.getValue()).getBrokerName(), ((BrokerAddrInfo)next.getKey()).getBrokerAddr(), ((BrokerLiveInfo)next.getValue()).getBrokerId()));
                log.warn("The broker channel {} expired, brokerInfo {}, expired {}ms", new Object[]{next.getValue().getChannel(), next.getKey(), timeoutMillis});
            }
        }
        catch (Exception e) {
            log.error("scanNotActiveBroker exception", (Throwable)e);
        }
    }

    private void notifyBrokerInActive(String clusterName, String brokerName, String brokerAddr, Long brokerId) {
        for (BrokerHeartbeatManager.BrokerLifecycleListener listener : this.brokerLifecycleListeners) {
            listener.onBrokerInactive(clusterName, brokerName, brokerAddr, brokerId);
        }
    }

    @Override
    public void addBrokerLifecycleListener(BrokerHeartbeatManager.BrokerLifecycleListener listener) {
        this.brokerLifecycleListeners.add(listener);
    }

    @Override
    public void onBrokerHeartbeat(String clusterName, String brokerName, String brokerAddr, Long brokerId, Long timeoutMillis, Channel channel, Integer epoch, Long maxOffset, Long confirmOffset, Integer electionPriority) {
        BrokerAddrInfo addrInfo = new BrokerAddrInfo(clusterName, brokerAddr);
        BrokerLiveInfo prev = this.brokerLiveTable.get(addrInfo);
        int realEpoch = Optional.ofNullable(epoch).orElse(-1);
        long realBrokerId = Optional.ofNullable(brokerId).orElse(-1L);
        long realMaxOffset = Optional.ofNullable(maxOffset).orElse(-1L);
        long realConfirmOffset = Optional.ofNullable(confirmOffset).orElse(-1L);
        long realTimeoutMillis = Optional.ofNullable(timeoutMillis).orElse(10000L);
        int realElectionPriority = Optional.ofNullable(electionPriority).orElse(Integer.MAX_VALUE);
        if (null == prev) {
            this.brokerLiveTable.put(addrInfo, new BrokerLiveInfo(brokerName, brokerAddr, realBrokerId, System.currentTimeMillis(), realTimeoutMillis, channel, realEpoch, realMaxOffset, realElectionPriority));
            log.info("new broker registered, {}, brokerId:{}", (Object)addrInfo, (Object)realBrokerId);
        } else {
            prev.setLastUpdateTimestamp(System.currentTimeMillis());
            prev.setHeartbeatTimeoutMillis(realTimeoutMillis);
            prev.setElectionPriority(realElectionPriority);
            prev.setBrokerId(realBrokerId);
            if (realEpoch > prev.getEpoch() || realEpoch == prev.getEpoch() && realMaxOffset > prev.getMaxOffset()) {
                prev.setEpoch(realEpoch);
                prev.setMaxOffset(realMaxOffset);
                prev.setConfirmOffset(realConfirmOffset);
            }
        }
    }

    @Override
    public void onBrokerChannelClose(Channel channel) {
        BrokerAddrInfo addrInfo = null;
        for (Map.Entry<BrokerAddrInfo, BrokerLiveInfo> entry : this.brokerLiveTable.entrySet()) {
            if (entry.getValue().getChannel() != channel) continue;
            log.info("Channel {} inactive, broker {}, addr:{}, id:{}", new Object[]{entry.getValue().getChannel(), entry.getValue().getBrokerName(), entry.getKey().getBrokerAddr(), entry.getValue().getBrokerId()});
            addrInfo = entry.getKey();
            this.executor.submit(() -> this.notifyBrokerInActive(((BrokerAddrInfo)entry.getKey()).getClusterName(), ((BrokerLiveInfo)entry.getValue()).getBrokerName(), ((BrokerAddrInfo)entry.getKey()).getBrokerAddr(), ((BrokerLiveInfo)entry.getValue()).getBrokerId()));
            break;
        }
        if (addrInfo != null) {
            this.brokerLiveTable.remove(addrInfo);
        }
    }

    @Override
    public BrokerLiveInfo getBrokerLiveInfo(String clusterName, String brokerAddr) {
        return this.brokerLiveTable.get(new BrokerAddrInfo(clusterName, brokerAddr));
    }

    @Override
    public boolean isBrokerActive(String clusterName, String brokerAddr) {
        BrokerLiveInfo info = this.brokerLiveTable.get(new BrokerAddrInfo(clusterName, brokerAddr));
        if (info != null) {
            long timeoutMillis;
            long last = info.getLastUpdateTimestamp();
            return last + (timeoutMillis = info.getHeartbeatTimeoutMillis()) >= System.currentTimeMillis();
        }
        return false;
    }
}

