/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.protocol.http2proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.Attribute;
import io.netty.util.DefaultAttributeMap;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.netty.AttributeKeys;

public class HAProxyMessageForwarder
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final Field FIELD_ATTRIBUTE = FieldUtils.getField(DefaultAttributeMap.class, (String)"attributes", (boolean)true);
    private final Channel outboundChannel;

    public HAProxyMessageForwarder(Channel outboundChannel) {
        this.outboundChannel = outboundChannel;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            this.forwardHAProxyMessage(ctx.channel(), this.outboundChannel);
            ctx.fireChannelRead(msg);
        }
        catch (Exception e) {
            log.error("Forward HAProxyMessage from Remoting to gRPC server error.", (Throwable)e);
            throw e;
        }
        finally {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private void forwardHAProxyMessage(Channel inboundChannel, Channel outboundChannel) throws Exception {
        if (!(inboundChannel instanceof DefaultAttributeMap)) {
            return;
        }
        HAProxyMessage message = this.buildHAProxyMessage(inboundChannel);
        if (message == null) {
            return;
        }
        outboundChannel.writeAndFlush((Object)message).sync();
    }

    protected HAProxyMessage buildHAProxyMessage(Channel inboundChannel) throws IllegalAccessException, DecoderException {
        String sourceAddress = null;
        String destinationAddress = null;
        int sourcePort = 0;
        int destinationPort = 0;
        if (inboundChannel.hasAttr(AttributeKeys.PROXY_PROTOCOL_ADDR)) {
            Object[] attributes = (Attribute[])FieldUtils.readField((Field)FIELD_ATTRIBUTE, (Object)inboundChannel);
            if (ArrayUtils.isEmpty((Object[])attributes)) {
                return null;
            }
            for (Object attribute : attributes) {
                String attributeValue;
                String attributeKey = attribute.key().name();
                if (!StringUtils.startsWith((CharSequence)attributeKey, (CharSequence)"proxy_protocol_") || StringUtils.isEmpty((CharSequence)(attributeValue = (String)attribute.get()))) continue;
                if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_ADDR) {
                    sourceAddress = attributeValue;
                }
                if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_PORT) {
                    sourcePort = Integer.parseInt(attributeValue);
                }
                if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_SERVER_ADDR) {
                    destinationAddress = attributeValue;
                }
                if (attribute.key() != AttributeKeys.PROXY_PROTOCOL_SERVER_PORT) continue;
                destinationPort = Integer.parseInt(attributeValue);
            }
        } else {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr((Channel)inboundChannel);
            sourceAddress = StringUtils.substringBefore((String)remoteAddr, (String)":");
            sourcePort = Integer.parseInt(StringUtils.substringAfterLast((String)remoteAddr, (String)":"));
            String localAddr = RemotingHelper.parseChannelLocalAddr((Channel)inboundChannel);
            destinationAddress = StringUtils.substringBefore((String)localAddr, (String)":");
            destinationPort = Integer.parseInt(StringUtils.substringAfterLast((String)localAddr, (String)":"));
        }
        HAProxyProxiedProtocol proxiedProtocol = AclUtils.isColon((String)sourceAddress) ? HAProxyProxiedProtocol.TCP6 : HAProxyProxiedProtocol.TCP4;
        List<HAProxyTLV> haProxyTLVs = this.buildHAProxyTLV(inboundChannel);
        return new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, proxiedProtocol, sourceAddress, destinationAddress, sourcePort, destinationPort, haProxyTLVs);
    }

    protected List<HAProxyTLV> buildHAProxyTLV(Channel inboundChannel) throws IllegalAccessException, DecoderException {
        ArrayList<HAProxyTLV> result = new ArrayList<HAProxyTLV>();
        if (!inboundChannel.hasAttr(AttributeKeys.PROXY_PROTOCOL_ADDR)) {
            return result;
        }
        Object[] attributes = (Attribute[])FieldUtils.readField((Field)FIELD_ATTRIBUTE, (Object)inboundChannel);
        if (ArrayUtils.isEmpty((Object[])attributes)) {
            return result;
        }
        for (Object attribute : attributes) {
            String attributeValue;
            HAProxyTLV haProxyTLV;
            String attributeKey = attribute.key().name();
            if (!StringUtils.startsWith((CharSequence)attributeKey, (CharSequence)"proxy_protocol_tlv_0x") || (haProxyTLV = this.buildHAProxyTLV(attributeKey, attributeValue = (String)attribute.get())) == null) continue;
            result.add(haProxyTLV);
        }
        return result;
    }

    protected HAProxyTLV buildHAProxyTLV(String attributeKey, String attributeValue) throws DecoderException {
        String typeString = StringUtils.substringAfter((String)attributeKey, (String)"proxy_protocol_tlv_0x");
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeBytes(attributeValue.getBytes(Charset.defaultCharset()));
        return new HAProxyTLV(Hex.decodeHex((String)typeString)[0], byteBuf);
    }
}

