/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.container;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.container.BrokerContainer;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class InnerBrokerController
extends BrokerController {
    protected BrokerContainer brokerContainer;

    public InnerBrokerController(BrokerContainer brokerContainer, BrokerConfig brokerConfig, MessageStoreConfig messageStoreConfig) {
        super(brokerConfig, messageStoreConfig);
        this.brokerContainer = brokerContainer;
        this.brokerOuterAPI = this.brokerContainer.getBrokerOuterAPI();
    }

    protected void initializeRemotingServer() {
        RemotingServer remotingServer = this.brokerContainer.getRemotingServer().newRemotingServer(this.brokerConfig.getListenPort());
        RemotingServer fastRemotingServer = this.brokerContainer.getRemotingServer().newRemotingServer(this.brokerConfig.getListenPort() - 2);
        this.setRemotingServer(remotingServer);
        this.setFastRemotingServer(fastRemotingServer);
    }

    protected void initializeScheduledTasks() {
        this.initializeBrokerScheduledTasks();
    }

    public void start() throws Exception {
        this.shouldStartTime = System.currentTimeMillis() + (long)this.messageStoreConfig.getDisappearTimeAfterStart();
        if (this.messageStoreConfig.getTotalReplicas() > 1 && this.brokerConfig.isEnableSlaveActingMaster()) {
            this.isIsolated = true;
        }
        this.startBasicService();
        if (!(this.isIsolated || this.messageStoreConfig.isEnableDLegerCommitLog() || this.messageStoreConfig.isDuplicationEnable())) {
            this.changeSpecialServiceStatus(this.brokerConfig.getBrokerId() == 0L);
            this.registerBrokerAll(true, false, true);
        }
        this.scheduledFutures.add(this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run0() {
                try {
                    if (System.currentTimeMillis() < InnerBrokerController.this.shouldStartTime) {
                        LOG.info("Register to namesrv after {}", (Object)InnerBrokerController.this.shouldStartTime);
                        return;
                    }
                    if (InnerBrokerController.this.isIsolated) {
                        LOG.info("Skip register for broker is isolated");
                        return;
                    }
                    InnerBrokerController.this.registerBrokerAll(true, false, InnerBrokerController.this.brokerConfig.isForceRegister());
                }
                catch (Throwable e) {
                    LOG.error("registerBrokerAll Exception", e);
                }
            }
        }, 10000L, Math.max(10000, Math.min(this.brokerConfig.getRegisterNameServerPeriod(), 60000)), TimeUnit.MILLISECONDS));
        if (this.brokerConfig.isEnableSlaveActingMaster()) {
            this.scheduleSendHeartbeat();
            this.scheduledFutures.add(this.syncBrokerMemberGroupExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

                public void run0() {
                    try {
                        InnerBrokerController.this.syncBrokerMemberGroup();
                    }
                    catch (Throwable e) {
                        LOG.error("sync BrokerMemberGroup error. ", e);
                    }
                }
            }, 1000L, this.brokerConfig.getSyncBrokerMemberGroupPeriod(), TimeUnit.MILLISECONDS));
        }
        if (this.brokerConfig.isEnableControllerMode()) {
            this.scheduleSendHeartbeat();
        }
        if (this.brokerConfig.isSkipPreOnline()) {
            this.startServiceWithoutCondition();
        }
    }

    public void shutdown() {
        this.shutdownBasicService();
        for (ScheduledFuture scheduledFuture : this.scheduledFutures) {
            scheduledFuture.cancel(true);
        }
        if (this.getRemotingServer() != null) {
            this.brokerContainer.getRemotingServer().removeRemotingServer(this.brokerConfig.getListenPort());
        }
        if (this.getFastRemotingServer() != null) {
            this.brokerContainer.getRemotingServer().removeRemotingServer(this.brokerConfig.getListenPort() - 2);
        }
    }

    public String getBrokerAddr() {
        return this.brokerConfig.getBrokerIP1() + ":" + this.brokerConfig.getListenPort();
    }

    public String getHAServerAddr() {
        return this.brokerConfig.getBrokerIP2() + ":" + this.messageStoreConfig.getHaListenPort();
    }

    public long getMinBrokerIdInGroup() {
        return this.minBrokerIdInGroup;
    }

    public int getListenPort() {
        return this.brokerConfig.getListenPort();
    }

    public BrokerOuterAPI getBrokerOuterAPI() {
        return this.brokerContainer.getBrokerOuterAPI();
    }

    public BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.brokerContainer.getNettyServerConfig();
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.brokerContainer.getNettyClientConfig();
    }

    public MessageStore getMessageStoreByBrokerName(String brokerName) {
        if (this.brokerConfig.getBrokerName().equals(brokerName)) {
            return this.getMessageStore();
        }
        BrokerController brokerController = this.brokerContainer.findBrokerControllerByBrokerName(brokerName);
        if (brokerController != null) {
            return brokerController.getMessageStore();
        }
        return null;
    }

    public BrokerController peekMasterBroker() {
        if (this.brokerConfig.getBrokerId() == 0L) {
            return this;
        }
        return this.brokerContainer.peekMasterBroker();
    }
}

