/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.ClassLoaderUtils$;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.proxy.ChildFirstClassLoader;
import org.apache.streampark.flink.proxy.ClassLoaderObjectInputStream;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FlinkShimsProxy$
implements org.apache.streampark.common.util.Logger {
    public static FlinkShimsProxy$ MODULE$;
    private final Pattern INCLUDE_PATTERN;
    private final Pattern SHIMS_PATTERN;
    private final Map<String, ClassLoader> SHIMS_CLASS_LOADER_CACHE;
    private final Map<String, ClassLoader> VERIFY_SQL_CLASS_LOADER_CACHE;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new FlinkShimsProxy$();
    }

    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private Pattern getFlinkShimsResourcePattern(String flinkLargeVersion) {
        return Pattern.compile(new StringBuilder(19).append("flink-(.*)-").append(flinkLargeVersion).append("(.*).jar").toString(), 34);
    }

    private Pattern getStreamParkLibPattern(String scalaVersion) {
        return Pattern.compile(new StringBuilder(25).append("streampark-(.*)_").append(scalaVersion).append("-(.*).jar").toString(), 34);
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function1<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0 & Serializable & scala.Serializable)() -> func.apply((Object)shimsClassLoader));
    }

    public <T> T proxy(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getFlinkShimsClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0 & Serializable & scala.Serializable)() -> func.apply(shimsClassLoader));
    }

    public ClassLoader getVerifySqlLibClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("add verify sql lib,flink version: ").append(flinkVersion).toString());
        return (ClassLoader)this.VERIFY_SQL_CLASS_LOADER_CACHE.getOrElseUpdate((Object)String.valueOf(flinkVersion.fullVersion()), (Function0 & Serializable & scala.Serializable)() -> {
            Function1 & Serializable & scala.Serializable getFlinkTable = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkShimsProxy$.$anonfun$getVerifySqlLibClassLoader$3(x$1));
            List<URL> libTableURL = MODULE$.getFlinkHomeLib(flinkVersion.flinkHome(), "lib", (Function1<File, Object>)getFlinkTable);
            List<URL> optTableURL = MODULE$.getFlinkHomeLib(flinkVersion.flinkHome(), "opt", (Function1<File, Object>)getFlinkTable);
            ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)libTableURL.$plus$plus(optTableURL, List$.MODULE$.canBuildFrom()));
            MODULE$.addShimsUrls(flinkVersion, (Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                FlinkShimsProxy$.$anonfun$getVerifySqlLibClassLoader$4(shimsUrls, file);
                return BoxedUnit.UNIT;
            });
            return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), MODULE$.getFlinkShimsResourcePattern(flinkVersion.majorVersion()));
        });
    }

    public void addShimsUrls(FlinkVersion flinkVersion, Function1<File, BoxedUnit> addShimUrl) {
        String appHome = System.getProperty(ConfigConst$.MODULE$.KEY_APP_HOME());
        Predef$.MODULE$.require(appHome != null, (Function0 & Serializable & scala.Serializable)() -> String.format("%s is not found on System env.", ConfigConst$.MODULE$.KEY_APP_HOME()));
        File libPath = new File(new StringBuilder(4).append(appHome).append("/lib").toString());
        Predef$.MODULE$.require(libPath.exists());
        String majorVersion = flinkVersion.majorVersion();
        String scalaVersion = flinkVersion.scalaVersion();
        Pattern streamParkMatcher = this.getStreamParkLibPattern(scalaVersion);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])libPath.listFiles())).foreach((Function1 & Serializable & scala.Serializable)jar -> {
            FlinkShimsProxy$.$anonfun$addShimsUrls$2(majorVersion, scalaVersion, addShimUrl, streamParkMatcher, jar);
            return BoxedUnit.UNIT;
        });
    }

    public <T> T proxyVerifySql(FlinkVersion flinkVersion, Function<ClassLoader, T> func) {
        ClassLoader shimsClassLoader = this.getVerifySqlLibClassLoader(flinkVersion);
        return (T)ClassLoaderUtils$.MODULE$.runAsClassLoader(shimsClassLoader, (Function0 & Serializable & scala.Serializable)() -> func.apply(shimsClassLoader));
    }

    private ClassLoader getFlinkShimsClassLoader(FlinkVersion flinkVersion) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("add flink shims urls classloader,flink version: ").append(flinkVersion).toString());
        return (ClassLoader)this.SHIMS_CLASS_LOADER_CACHE.getOrElseUpdate((Object)String.valueOf(flinkVersion.fullVersion()), (Function0 & Serializable & scala.Serializable)() -> {
            List<URL> libURL = MODULE$.getFlinkHomeLib(flinkVersion.flinkHome(), "lib", (Function1<File, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkShimsProxy$.$anonfun$getFlinkShimsClassLoader$3(x$2)));
            ListBuffer shimsUrls = (ListBuffer)ListBuffer$.MODULE$.apply(libURL);
            MODULE$.addShimsUrls(flinkVersion, (Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
                FlinkShimsProxy$.$anonfun$getFlinkShimsClassLoader$4(shimsUrls, file);
                return BoxedUnit.UNIT;
            });
            return new ChildFirstClassLoader((URL[])shimsUrls.toArray(ClassTag$.MODULE$.apply(URL.class)), Thread.currentThread().getContextClassLoader(), MODULE$.getFlinkShimsResourcePattern(flinkVersion.majorVersion()));
        });
    }

    private List<URL> getFlinkHomeLib(String flinkHome, String childDir, Function1<File, Object> filterFun) {
        File file = new File(flinkHome, childDir);
        Predef$.MODULE$.require(file.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("FLINK_HOME ").append(file).append(" does not exist").toString());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).filter(filterFun))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList();
    }

    public <T> T getObject(ClassLoader loader, Object obj) throws Exception {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        Object result = Utils$.MODULE$.tryWithResource((AutoCloseable)new ObjectOutputStream(arrayOutputStream), (Function1 & Serializable & scala.Serializable)objectOutputStream -> {
            objectOutputStream.writeObject(obj);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(arrayOutputStream.toByteArray());
            return Utils$.MODULE$.tryWithResource((AutoCloseable)new ClassLoaderObjectInputStream(loader, byteArrayInputStream), (Function1 & Serializable & scala.Serializable)x$4 -> x$4.readObject(), (Function1)Predef$.MODULE$.$conforms());
        }, (Function1)Predef$.MODULE$.$conforms());
        return (T)result;
    }

    public static final /* synthetic */ boolean $anonfun$getVerifySqlLibClassLoader$3(File x$1) {
        return x$1.getName().startsWith("flink-table");
    }

    public static final /* synthetic */ void $anonfun$getVerifySqlLibClassLoader$4(ListBuffer shimsUrls$1, File file) {
        block0: {
            if (file == null || !file.getName().startsWith("streampark-flink-shims")) break block0;
            shimsUrls$1.$plus$eq((Object)file.toURI().toURL());
        }
    }

    public static final /* synthetic */ void $anonfun$addShimsUrls$2(String majorVersion$1, String scalaVersion$1, Function1 addShimUrl$1, Pattern streamParkMatcher$1, File jar) {
        block6: {
            try {
                Matcher shimsMatcher = FlinkShimsProxy$.MODULE$.SHIMS_PATTERN.matcher(jar.getName());
                if (shimsMatcher.matches()) {
                    String string = majorVersion$1;
                    String string2 = shimsMatcher.group(1);
                    if (string != null ? !string.equals(string2) : string2 != null) break block6;
                    String string3 = scalaVersion$1;
                    String string4 = shimsMatcher.group(2);
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        addShimUrl$1.apply((Object)jar);
                    }
                    break block6;
                }
                if (FlinkShimsProxy$.MODULE$.INCLUDE_PATTERN.matcher(jar.getName()).matches()) {
                    addShimUrl$1.apply((Object)jar);
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("include jar lib: ").append(jar.getName()).toString());
                }
                if (streamParkMatcher$1.matcher(jar.getName()).matches()) {
                    addShimUrl$1.apply((Object)jar);
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("include streampark lib: ").append(jar.getName()).toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFlinkShimsClassLoader$3(File x$2) {
        return !x$2.getName().startsWith("log4j");
    }

    public static final /* synthetic */ void $anonfun$getFlinkShimsClassLoader$4(ListBuffer shimsUrls$2, File file) {
        block0: {
            if (file == null) break block0;
            shimsUrls$2.$plus$eq((Object)file.toURI().toURL());
        }
    }

    private FlinkShimsProxy$() {
        MODULE$ = this;
        org.apache.streampark.common.util.Logger.$init$((org.apache.streampark.common.util.Logger)this);
        this.INCLUDE_PATTERN = Pattern.compile("(json4s|jackson)(.*).jar", 34);
        this.SHIMS_PATTERN = Pattern.compile("streampark-flink-shims_flink-(1.12|1.13|1.14|1.15|1.16)_(2.11|2.12)-(.*).jar", 34);
        this.SHIMS_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.VERIFY_SQL_CLASS_LOADER_CACHE = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

